<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Requestforquote
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */


namespace Webkul\Requestforquote\Api\Data;

interface CategoryAttributeMappingInterface
{

    const ENTITY_ID = 'entity_id';

    const ATTRIBUTE_SET_ID = 'attribute_set_id';

    const CATEGORY_ID = 'category_id';

    const CATEGORY_PATH = 'category_path';

    /**
     * Set EntityId
     *
     * @param int $entityId
     * @return Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterface
     */
    public function setEntityId($entityId);
    /**
     * Get EntityId
     *
     * @return int
     */
    public function getEntityId();
    /**
     * Set AttributeSetId
     *
     * @param int $attributeSetId
     * @return Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterface
     */
    public function setAttributeSetId($attributeSetId);
    /**
     * Get AttributeSetId
     *
     * @return int
     */
    public function getAttributeSetId();
    /**
     * Set CategoryId
     *
     * @param int $categoryId
     * @return Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterface
     */
    public function setCategoryId($categoryId);
    /**
     * Get CategoryId
     *
     * @return int
     */
    public function getCategoryId();
    /**
     * Set CategoryPath
     *
     * @param string $categoryPath
     * @return Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterface
     */
    public function setCategoryPath($categoryPath);
    /**
     * Get CategoryPath
     *
     * @return string
     */
    public function getCategoryPath();
}
