<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Requestforquote
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */


namespace Webkul\Requestforquote\Api\Data;

interface ConversationInterface
{

    const ENTITY_ID = 'entity_id';

    const SELLER_QUOTE_ID = 'seller_quote_id';

    const RESPONSE = 'response';

    const SAMPLE_IMAGES = 'sample_images';

    const BULK_QUOTE_QTY = 'bulk_quote_qty';

    const QUOTE_PRICE = 'quote_price';

    const SENDER_TYPE = 'sender_type';

    const CREATED_AT = 'created_at';

    const UPDATED_AT = 'updated_at';

    /**
     * Set EntityId
     *
     * @param int $entityId
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setEntityId($entityId);
    /**
     * Get EntityId
     *
     * @return int
     */
    public function getEntityId();
    /**
     * Set SellerQuoteId
     *
     * @param int $sellerQuoteId
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setSellerQuoteId($sellerQuoteId);
    /**
     * Get SellerQuoteId
     *
     * @return int
     */
    public function getSellerQuoteId();
    /**
     * Set Response
     *
     * @param string $response
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setResponse($response);
    /**
     * Get Response
     *
     * @return string
     */
    public function getResponse();
    /**
     * Set SampleImages
     *
     * @param string $sampleImages
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setSampleImages($sampleImages);
    /**
     * Get SampleImages
     *
     * @return string
     */
    public function getSampleImages();
    /**
     * Set BulkQuoteQty
     *
     * @param int $bulkQuoteQty
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setBulkQuoteQty($bulkQuoteQty);
    /**
     * Get BulkQuoteQty
     *
     * @return int
     */
    public function getBulkQuoteQty();
    /**
     * Set QuotePrice
     *
     * @param float $quotePrice
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setQuotePrice($quotePrice);
    /**
     * Get QuotePrice
     *
     * @return float
     */
    public function getQuotePrice();
    /**
     * Set SenderType
     *
     * @param int $senderType
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setSenderType($senderType);
    /**
     * Get SenderType
     *
     * @return int
     */
    public function getSenderType();
    /**
     * Set CreatedAt
     *
     * @param string $createdAt
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setCreatedAt($createdAt);
    /**
     * Get CreatedAt
     *
     * @return string
     */
    public function getCreatedAt();
    /**
     * Set UpdatedAt
     *
     * @param string $updatedAt
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setUpdatedAt($updatedAt);
    /**
     * Get UpdatedAt
     *
     * @return string
     */
    public function getUpdatedAt();
}
