<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Requestforquote
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */


namespace Webkul\Requestforquote\Api\Data;

interface QuoteInterface
{

    const ENTITY_ID = 'entity_id';

    const CUSTOMER_ID = 'customer_id';

    const PRODUCT_ID = 'product_id';

    const PRODUCT_WEIGHT = 'product_weight';

    const TAX_CLASS_ID = 'tax_class_id';

    const SUBJECT = 'subject';

    const DESCRIPTION = 'description';

    const ATTRIBUTE_DESCRIPTION = 'attribute_description';

    const SAMPLE_IMAGES = 'sample_images';

    const BULK_ORDER_QTY = 'bulk_order_qty';

    const UNIT_PRICE = 'unit_price';

    const DESTINATION_COUNTRY = 'destination_country';

    const STATUS = 'status';

    const APPROVED_SELLER_QUOTE_ID = 'approved_seller_quote_id';

    const CREATED_AT = 'created_at';

    const UPDATED_AT = 'updated_at';

    /**
     * Set EntityId
     *
     * @param int $entityId
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setEntityId($entityId);
    /**
     * Get EntityId
     *
     * @return int
     */
    public function getEntityId();
    /**
     * Set CustomerId
     *
     * @param int $customerId
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setCustomerId($customerId);
    /**
     * Get CustomerId
     *
     * @return int
     */
    public function getCustomerId();
    /**
     * Set ProductId
     *
     * @param int $productId
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setProductId($productId);
    /**
     * Get ProductId
     *
     * @return int
     */
    public function getProductId();
    /**
     * Set ProductWeight
     *
     * @param int $productWeight
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setProductWeight($productWeight);
    /**
     * Get ProductWeight
     *
     * @return int
     */
    public function getProductWeight();
    /**
     * Set TaxClassId
     *
     * @param int $taxClassId
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setTaxClassId($taxClassId);
    /**
     * Get TaxClassId
     *
     * @return int
     */
    public function getTaxClassId();
    /**
     * Set Subject
     *
     * @param string $subject
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setSubject($subject);
    /**
     * Get Subject
     *
     * @return string
     */
    public function getSubject();
    /**
     * Set Description
     *
     * @param string $description
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setDescription($description);
    /**
     * Get Description
     *
     * @return string
     */
    public function getDescription();
    /**
     * Set AttributeDescription
     *
     * @param string $attributeDescription
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setAttributeDescription($attributeDescription);
    /**
     * Get AttributeDescription
     *
     * @return string
     */
    public function getAttributeDescription();
    /**
     * Set SampleImages
     *
     * @param string $sampleImages
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setSampleImages($sampleImages);
    /**
     * Get SampleImages
     *
     * @return string
     */
    public function getSampleImages();
    /**
     * Set BulkOrderQty
     *
     * @param int $bulkOrderQty
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setBulkOrderQty($bulkOrderQty);
    /**
     * Get BulkOrderQty
     *
     * @return int
     */
    public function getBulkOrderQty();
    /**
     * Set UnitPrice
     *
     * @param float $unitPrice
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setUnitPrice($unitPrice);
    /**
     * Get UnitPrice
     *
     * @return float
     */
    public function getUnitPrice();
    /**
     * Set DestinationCountry
     *
     * @param string $destinationCountry
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setDestinationCountry($destinationCountry);
    /**
     * Get DestinationCountry
     *
     * @return string
     */
    public function getDestinationCountry();
    /**
     * Set Status
     *
     * @param int $status
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setStatus($status);
    /**
     * Get Status
     *
     * @return int
     */
    public function getStatus();
    /**
     * Set ApprovedSellerQuoteId
     *
     * @param int $approvedSellerQuoteId
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setApprovedSellerQuoteId($approvedSellerQuoteId);
    /**
     * Get ApprovedSellerQuoteId
     *
     * @return int
     */
    public function getApprovedSellerQuoteId();
    /**
     * Set CreatedAt
     *
     * @param string $createdAt
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setCreatedAt($createdAt);
    /**
     * Get CreatedAt
     *
     * @return string
     */
    public function getCreatedAt();
    /**
     * Set UpdatedAt
     *
     * @param string $updatedAt
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setUpdatedAt($updatedAt);
    /**
     * Get UpdatedAt
     *
     * @return string
     */
    public function getUpdatedAt();
}
