<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Requestforquote
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */


namespace Webkul\Requestforquote\Api;

interface ManageattributeRepositoryInterface
{
    /**
     * get by id
     *
     * @param int $id
     * @return Webkul\Requestforquote\Model\Manageattribute
     */
    public function getById($id);
    /**
     * get by id
     *
     * @param int $id
     * @return Webkul\Requestforquote\Model\Manageattribute
     */
    public function save(\Webkul\Requestforquote\Model\Manageattribute $subject);
    /**
     * get list
     *
     * @param Magento\Framework\Api\SearchCriteriaInterface $creteria
     * @return Magento\Framework\Api\SearchResults
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $creteria);
    /**
     * delete
     *
     * @param Webkul\Requestforquote\Model\Manageattribute $subject
     * @return boolean
     */
    public function delete(\Webkul\Requestforquote\Model\Manageattribute $subject);
    /**
     * delete by id
     *
     * @param int $id
     * @return boolean
     */
    public function deleteById($id);
}
