<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Block\Account\Customer;

class Lists extends \Magento\Framework\View\Element\Template
{
    /**
     * @var \Webkul\Requestforquote\Model\ResourceModel\Quote\CollectionFactory
     */
    private $quoteFactory;

    /**
     * @var \Webkul\Marketplace\Helper\Data
     */
    private $mpHelper;
    
    /**
     * __construct function
     *
     * @param \Magento\Framework\View\Element\Template\Context                    $context
     * @param \Webkul\Requestforquote\Model\ResourceModel\Quote\CollectionFactory $quoteFactory
     * @param \Webkul\Marketplace\Helper\Data                                     $mpHelper
     * @param array                                                               $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Webkul\Requestforquote\Model\ResourceModel\Quote\CollectionFactory $quoteFactory,
        \Webkul\Marketplace\Helper\Data $mpHelper,
        \Webkul\Requestforquote\Helper\Data $helper,
        array $data = []
    ) {
        $this->quoteFactory = $quoteFactory;
        $this->mpHelper = $mpHelper;
        $this->helper = $helper;
        parent::__construct($context, $data);

        $filter = '';
        $filterStatus = '';
        $filterDateFrom = '';
        $filterDateTo = '';
        if ($quoteKeyword = $this->getRequest()->getParam('s')) {
            $filter = $quoteKeyword != "" ? $quoteKeyword : "";
        }
        if ($this->getRequest()->getParam('status') != '') {
            $quoteStatus = $this->getRequest()->getParam('status');
            $filterStatus = $quoteStatus != "" ? $quoteStatus : "";
        }
        $quoteFromDate = $this->getRequest()->getParam('from_date');

        if ($quoteFromDate = $this->getRequest()->getParam('from_date')) {
            $filterDateFrom = $quoteFromDate != "" ? $quoteFromDate : "";
        }
        if ($quoteToDate = $this->getRequest()->getParam('to_date')) {
            $filterDateTo = $quoteToDate != "" ? $quoteToDate." 23:59:59" : "";
        }
        $customerId = $this->mpHelper->getCustomerId();
        $quotes = $this->quoteFactory->create()
            ->addFieldToFilter('customer_id', $customerId);
        if ($filter) {
            $quotes->addFieldToFilter('subject', ['like'=>"%".$filter."%"]);
        }
        if ($filterStatus != '') {
            $quotes->addFieldToFilter('status', $filterStatus);
        }
        if ($filterDateFrom != '' && $filterDateTo != '') {
            $quotes->addFieldToFilter(
                'created_at',
                [
                    'datetime' => true,
                    'from' => $filterDateFrom,
                    'to' =>  $filterDateTo
                ]
            );
        }
        $quotes->setOrder('entity_id', 'DESC');
        $this->setCollection($quotes);
    }

    /**
     * @return array
     */
    public function requestData()
    {
        return $this->getRequest()->getParams();
    }
    
    /**
     * getRequestedQuote get the Quote collection
     *
     * @return \Webkul\Requestforquote\Model\ResourceModel\Quote\Collection
     */
    public function getRequestedQuote()
    {
        return $this->getCollection();
    }
    
    /**
     * _prepareLayout
     *
     * @return void
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        if ($this->getCollection()) {
            $pager = $this->getLayout()->createBlock(
                \Magento\Theme\Block\Html\Pager::class,
                'taxmanager.taxrules.list.pager'
            )->setCollection(
                $this->getCollection()
            );
            $this->setChild('pager', $pager);
            $this->getCollection()->load();
        }
        return $this;
    }

    /**
     * @return string
     */
    public function getPagerHtml()
    {
        return $this->getChildHtml('pager');
    }

    public function getHelperObj()
    {
        return $this->helper;
    }

    public function getRequestObj()
    {
        return $this->getRequest();
    }
}
