<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Block\Account\Seller;

class Lists extends \Magento\Framework\View\Element\Template
{
    /**
     * @var \Magento\Customer\Model\CustomerFactory
     */
    private $customerFactory;

    /**
     * @var \Webkul\Requestforquote\Model\ResourceModel\Info\CollectionFactory
     */
    private $infoFactory;

    /**
     * @var \Webkul\Requestforquote\Model\QuoteFactory
     */
    private $quote;
    
    /**
     * @var \Magento\Eav\Model\ResourceModel\Entity\Attribute
     */
    private $eavAttribute;
    
    /**
     * @var \Webkul\Marketplace\Helper\Data
     */
    private $mpHelper;
    
    /**
     * __construct function
     *
     * @param \Magento\Framework\View\Element\Template\Context                   $context
     * @param \Magento\Customer\Model\CustomerFactory                            $customerFactory
     * @param \Webkul\Requestforquote\Model\ResourceModel\Info\CollectionFactory $infoFactory
     * @param \Webkul\Requestforquote\Model\QuoteFactory                         $quote
     * @param \Magento\Eav\Model\ResourceModel\Entity\Attribute                  $eavAttribute
     * @param \Webkul\Marketplace\Helper\Data                                    $mpHelper
     * @param array                                                              $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Customer\Model\CustomerFactory $customerFactory,
        \Webkul\Requestforquote\Model\ResourceModel\Info\CollectionFactory $infoFactory,
        \Webkul\Requestforquote\Model\QuoteFactory $quote,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute $eavAttribute,
        \Webkul\Requestforquote\Helper\Data $helper,
        \Webkul\Marketplace\Helper\Data $mpHelper,
        array $data = []
    ) {
        $this->customerFactory = $customerFactory;
        $this->infoFactory = $infoFactory;
        $this->quote = $quote;
        $this->eavAttribute = $eavAttribute;
        $this->mpHelper = $mpHelper;
        $this->helper = $helper;
        parent::__construct($context, $data);
        $customerId = $this->mpHelper->getCustomerId();
        $filter = '';
        $filterDateFrom = '';
        $filterDateTo = '';
        if ($quoteKeyword = $this->getRequest()->getParam('s')) {
            $filter = $quoteKeyword != "" ? $quoteKeyword : "";
        }
        if ($quoteFromDate = $this->getRequest()->getParam('from_date')) {
            $filterDateFrom = $quoteFromDate != "" ? $quoteFromDate : "";
        }
        if ($quoteToDate = $this->getRequest()->getParam('to_date')) {
            $filterDateTo = $quoteToDate != "" ? $quoteToDate." 23:59:59" : "";
        }
        $filterStatus = 1;
        if ($this->getRequest()->getParam('status') != '') {
            $status = $this->getRequest()->getParam('status');
            $filterStatus = $status != '' ? $status : '';
        }
        $sellerId = $this->mpHelper->getCustomerId();
        $quotes = $this->infoFactory->create()
            ->addFieldToFilter('seller_id', $sellerId);
        if ($filter) {
            $quotes->addFieldToFilter('subject', ['like'=>"%".$filter."%"]);
        }
        if ($filterDateFrom && $filterDateTo) {
            $quotes->getSelect()
                ->where('main_table.created_at >= "'.
                $filterDateFrom.'" AND main_table.created_at <= "'.$filterDateTo.'"');
        }
        $quotes->getSelect()
            ->join(
                [
                "rfq" => $quotes->getResource()->getTable("requestforquote_quote")
                ],
                "rfq.entity_id = main_table.quote_id",
                [
                "subject" => "subject",
                "description" => "description",
                "customer_id" => "customer_id"
                ]
            );
        $quotes ->getSelect()
            ->order('main_table.created_at DESC');
        $fnameid = $this->eavAttribute->getIdByCode('customer', 'firstname');
        $lnameid = $this->eavAttribute->getIdByCode('customer', 'lastname');
        $quotes->getSelect()
            ->join(
                [
                "ce1" => $quotes->getResource()->getTable("customer_entity")
                ],
                "ce1.entity_id = rfq.customer_id",
                [
                "firstname" => "firstname",
                "lastname" => "lastname"
                ]
            )->where(
                "ce1.entity_id = rfq.customer_id"
            )
            ->columns(
                new \Zend_Db_Expr(
                    "CONCAT(`ce1`.`firstname`, ' ',`ce1`.`lastname`) AS customer_name"
                )
            );

        $quotes->addFilterToMap("customer_name", "`ce1`.`value`");

        if ($filterStatus!='') {
            $quotes->getSelect()->where(
                "main_table.status = ".$filterStatus
            );
        }
        $this->setCollection($quotes);
    }

    /**
     * get filter data for rate
     *
     * @return array
     */
    public function requestData()
    {
        return $this->getRequest()->getParams();
    }

    /**
     * getRequestedQuote function
     *
     * @return object
     */
    public function getRequestedQuote()
    {
        return $this->getCollection();
    }

    /**
     * _prepareLayout prepare pager for rules list
     *
     * @return void
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        if ($this->getCollection()) {
            $pager = $this->getLayout()->createBlock(
                \Magento\Theme\Block\Html\Pager::class,
                'taxmanager.taxrules.list.pager'
            )->setCollection(
                $this->getCollection()
            );
            $this->setChild('pager', $pager);
            $this->getCollection()->load();
        }

        return $this;
    }

    /**
     * @return string
     */
    public function getPagerHtml()
    {
        return $this->getChildHtml('pager');
    }

    /**
     * Get requested quote count by status
     *
     * @param  int $quoteId
     * @param  int $status
     * @return Webkul_Requestforquote_Model_Quote
     */
    public function getRequestedQuoteCountByStatus($status)
    {
        $sellerId = $this->mpHelper->getCustomerId();
        $quotes = $this->infoFactory->create()
            ->addFieldToFilter('seller_id', $sellerId)
            ->addFieldToFilter('status', $status);
        return count($quotes);
    }

    /**
     * Get requested quote data
     *
     * @return Webkul_Requestforquote_Model_Quote
     */
    public function getQuoteById()
    {
        $quoteId = $this->getRequest()->getParam('id');
        return $this->quote->create()->load($quoteId);
    }

    /**
     * Get requested quote view url by quoteId
     *
     * @param  $quoteId
     * @return string
     */
    public function getViewUrl($quoteId)
    {
        return $this->getUrl('*/*/view', ['id' => $quoteId]);
    }

    /**
     * Get requested open quote url
     *
     * @return string
     */
    public function getOpenQuoteUrl()
    {
        $quoteId = $this->getRequest()->getParam('id');
        return $this->getUrl('*/*/lists', ['id' => $quoteId, 'status' => 1]);
    }

    /**
     * Get requested pending quote url
     *
     * @return string
     */
    public function getPendingQuoteUrl()
    {
        $quoteId = $this->getRequest()->getParam('id');
        return $this->getUrl('*/*/lists', ['id' => $quoteId, 'status' => 0]);
    }

    /**
     * Get requested answered quote url
     *
     * @return string
     */
    public function getAnsweredQuoteUrl()
    {
        $quoteId = $this->getRequest()->getParam('id');
        return $this->getUrl('*/*/lists', ['id' => $quoteId, 'status' => 2]);
    }

    /**
     * Get requested solved quote url
     *
     * @return string
     */
    public function getSolvedQuoteUrl()
    {
        $quoteId = $this->getRequest()->getParam('id');
        return $this->getUrl('*/*/lists', ['id' => $quoteId, 'status' => 3]);
    }

    /**
     * Get requested closed quote url
     *
     * @return string
     */
    public function getClosedQuoteUrl()
    {
        $quoteId = $this->getRequest()->getParam('id');
        return $this->getUrl('*/*/lists', ['id' => $quoteId, 'status' => 4]);
    }

    public function getHelperObj()
    {
        return $this->helper;
    }

    public function getRequestObj()
    {
        return $this->getRequest();
    }
}
