<?php
 /**
  * Webkul Software.
  *
  * @category  Webkul
  * @package   Webkul_Requestforquote
  * @author    Webkul
  * @copyright Copyright (c)  Webkul Software Private Limited (https://webkul.com)
  * @license   https://store.webkul.com/license.html
  */

namespace Webkul\Requestforquote\Block\Adminhtml\Mapping;
 
use Magento\Customer\Controller\RegistryConstants;
use Magento\Eav\Model\ResourceModel\Entity\Attribute\Group\CollectionFactory as AttributeGroupColl;

class MapAttributesToSet extends \Magento\Backend\Block\Template
{
    /**
     * Block template
     *
     * @var string
     */
    protected $_template = 'Webkul_Requestforquote::mapping/map_attribute_to_set.phtml';

    /**
     * @var Magento\Eav\Model\ResourceModel\Entity\Attribute\Group\CollectionFactory
     */
    protected $attributeGroupCollection;
    /**
     * @var \Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterfaceFactory
     */
    protected $mapping;

   /**
    * @param \Magento\Backend\Block\Template\Context $context
    * @param MappingCollection $mapping
    * @param AttributeGroupColl $attributeGroupCollection
    * @param array $data
    */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        AttributeGroupColl $attributeGroupCollection,
        \Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterfaceFactory $categoryAttributeMapping,
        array $data = []
    ) {
        $this->mapping = $categoryAttributeMapping;
        $this->attributeGroupCollection=$attributeGroupCollection;
        parent::__construct($context, $data);
    }

    /**
     * get mapping Id
     *
     * @return void
     */
    public function getMappingId()
    {
        if ($this->getRequest()->getParam('id')) {
            return $this->getRequest()->getParam('id');
        }
        return '';
    }

  /**
   * get attribute set Id
   *
   * @return int
   */
    public function getAttributeSetId()
    {
        $attributeSetId='';
        $mappingRowId=$this->getMappingId();
        if ($mappingRowId) {
            $mappingColl = $this->mapping->create()->load($mappingRowId, 'entity_id');
            if ($mappingColl->getId()) {
                $attributeSetId = $mappingColl->getAttributeSetId();
            }
        }
        return $attributeSetId;
    }
    
    /**
     * get attributes group
     *
     * @return array
     */
    public function getAttributeGroups()
    {
        $attributeSetId = $this->getAttributeSetId();
        $groupIds = [];
        $attributeids = [];
        $groupCollection='';
        if ($attributeSetId=="") {
            $groupCollection = $this->attributeGroupCollection->create()
            ->setAttributeSetFilter($attributeSetId)
            ->setOrder('sort_order', 'ASC')
            ->load(); // product attribute group collection
            $groupCollection = $this->attributeGroupCollection->create()
            ->setOrder('sort_order', 'ASC')
            ->load();
        }
        return $groupCollection;
    }
}
