<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Block\Adminhtml\Seller;

class Grid extends \Magento\Backend\Block\Widget\Grid\Extended
{
    protected $sellerFactory;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Backend\Helper\Data $backendHelper,
        \Webkul\Marketplace\Model\ResourceModel\Seller\Grid\CollectionFactory $sellerFactory,
        \Magento\Framework\Registry $coreRegistry,
        array $data = []
    ) {
        $this->sellerFactory = $sellerFactory;
        $this->_coreRegistry = $coreRegistry;
        parent::__construct($context, $backendHelper, $data);
    }

    /**
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();
        $this->setId('seller_tab_grid');
        $this->setDefaultSort('entity_id');
        $this->setUseAjax(true);
    }

    /**
     * @return Grid
     */
    protected function _prepareCollection()
    {
        $collection = $this->sellerFactory->create();
        $collection->addFieldToFilter('is_seller', 1);
        $this->setCollection($collection);
        return parent::_prepareCollection();
    }

    /**
     * @return Extended
     */
    protected function _prepareColumns()
    {
        $this->addColumn(
            'seller_quoteassign',
            [
                'type' => 'checkbox',
                'name' => 'seller_quoteassign',
                'index' => 'entity_id',
                'data-form-part' => $this->getData('target_form'),
                'header_css_class' => 'col-select col-massaction',
                'column_css_class' => 'col-select col-massaction'
            ]
        );
        $this->addColumn(
            'seller_id',
            [
                'header' => __('Seller Id'),
                'sortable' => true,
                'index' => 'seller_id',
                'header_css_class' => 'col-id',
                'column_css_class' => 'col-id'
            ]
        );
        $this->addColumn(
            'name',
            [
                'header' => __('Seller Name'),
                'index' => 'name',
            ]
        );
        $this->addColumn(
            'email',
            [
                'header' => __('Seller Email'),
                'index' => 'email'
            ]
        );

        return parent::_prepareColumns();
    }

    /**
     * @return string
     */
    public function getGridUrl()
    {
        return $this->getUrl('requestforquote/seller/grid', ['_current' => true]);
    }
}
