<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Block;

use Magento\Catalog\Model\ResourceModel\Eav\AttributeFactory;

class SubmitQuote extends \Magento\Framework\View\Element\Template
{

    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    private $product;

    /**
     * @var \Webkul\Requestforquote\Model\ManageattributeFactory
     */
    private $manageattribute;
    
    /**
     * @var \Magento\Framework\App\Filesystem\DirectoryList
     */
    private $directoryList;

    /**
     * @var integer\Webkul\Requestforquote\Helper\Data
     */
    private $helper;

    /**
     * @var \Magento\Eav\Model\ResourceModel\Entity\AttributeFactory
     */
    protected $eavAttribute;
    /**
     * @var \Magento\Catalog\Model\ResourceModel\Eav\AttributeFactory
     */
    protected $attributeFactory;

    /**
     * __construct function
     *
     * @param \Magento\Framework\View\Element\Template\Context     $context
     * @param \Webkul\Requestforquote\Model\ManageattributeFactory $manageattribute
     * @param \Magento\Catalog\Model\ProductFactory                $product
     * @param \Magento\Framework\App\Filesystem\DirectoryList      $directoryList
     * @param array                                                $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Webkul\Requestforquote\Model\ManageattributeFactory $manageattribute,
        \Webkul\Requestforquote\Api\Data\MapGroupAttributeIdInterfaceFactory $mapGroupAttributeId,
        \Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterfaceFactory $categoryAttributeMapping,
        \Magento\Catalog\Model\ProductFactory $product,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList,
        AttributeFactory $attributeFactory,
        \Magento\Eav\Model\Entity\AttributeFactory $eavAttribute,
        \Webkul\Requestforquote\Helper\Data $helper,
        \Webkul\Marketplace\Helper\Data $mpHelper,
        \Magento\Catalog\Helper\Output $catalogOutputHelper,
        \Magento\Framework\Filesystem\Io\File $filesystemFile,
        \Magento\Framework\Pricing\Helper\Data $pricingHelper,
        \Magento\Catalog\Helper\Image $catalogImageHelper,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        array $data = []
    ) {
        $this->manageattribute = $manageattribute;
        $this->product = $product;
        $this->directoryList = $directoryList;
        parent::__construct($context, $data);
        $this->eavAttribute = $eavAttribute;
        $this->attributeFactory = $attributeFactory;
        $this->helper = $helper;
        $this->filesystemFile = $filesystemFile;
        $this->pricingHelper = $pricingHelper;
        $this->mpHelper = $mpHelper;
        $this->jsonHelper = $jsonHelper;
        $this->categoryAttributeMapping = $categoryAttributeMapping;
        $this->mapGroupAttributeId = $mapGroupAttributeId;
        $this->catalogOutputHelper = $catalogOutputHelper;
        $this->catalogImageHelper = $catalogImageHelper;
    }

    /**
     * get Product
     *
     * @return Magento\Catalog\Model\Product
     */
    public function getProductId()
    {
        $id = $this->getRequest()->getParam('product_id');
        return $id;
    }
    
    /**
     * getProductDetails get the product model loaded by id of product
     *
     * @param  [int] $productId
     * @return /Magento/Catalog/Product/Model
     */
    public function getProductDetails($productId)
    {
        return $this->product->create()->load($productId);
    }

    /**
     * $excludeAttr is optional array of attribute codes to
     * exclude them from additional data array
     *
     * @param  array $excludeAttr
     * @return array
     */
    public function getAdditionalData(array $excludeAttr = [])
    {
        $data = [];
        $productId = $this->getRequest()->getParam('product_id');
        $product = $this->getProductDetails($productId);
        $attributes = $product->getAttributes();
        foreach ($attributes as $attribute) {
            if ($attribute->getIsVisibleOnFront() && !in_array($attribute->getAttributeCode(), $excludeAttr)) {
                $value = $attribute->getFrontend()->getValue($product);

                if (!$product->hasData($attribute->getAttributeCode())) {
                    $value = 'N/A';
                } elseif ((string)$value == '') {
                    $value = 'No';
                } elseif ($attribute->getFrontendInput() == 'price' && is_string($value)) {
                    $value = $value;
                }

                if (is_string($value) && strlen($value)) {
                    $data[$attribute->getAttributeCode()] = [
                        'label' => $attribute->getStoreLabel(),
                        'value' => $value,
                        'code'  => $attribute->getAttributeCode()
                        ];
                }
            }
        }
        return $data;
    }
    
    /**
     * getAdminDefinedAttributeId get the ids of attributes defined by admin
     *
     * @return array
     */
    public function getAdminDefinedAttributeId()
    {
        $ids = [];
        $adminDefinedAttributes=$this->manageattribute->create()->getCollection()->getData();
        foreach ($adminDefinedAttributes as $adminDefinedAttribute) {
            $ids[] = $adminDefinedAttribute['attribute_id'];
        }
        return $ids;
    }
    
    /**
     * getAdminDefinedAttributeData get the attribute data defined by admin
     *
     * @return array
     */
    public function getAdminDefinedAttributeData()
    {
        $this->helper->clearCache();
        $data = [];
        $productId = $this->getRequest()->getParam('product_id');
        $product = $this->getProductDetails($productId);
        $adminDefinedAttributes=$this->manageattribute->create()->getCollection()->getData();
        $ids = $this->getAdminDefinedAttributeId();
        if (isset($productId) && $productId!="") {
            foreach ($adminDefinedAttributes as $adminDefinedAttribute) {
                    $attribute = $product->getResource()->getAttribute($adminDefinedAttribute['attribute_code']);
                    $value = $attribute->getFrontend()->getValue($product);
                if (!$product->hasData($attribute->getAttributeCode())) {
                    $value = 'N/A';
                } elseif ((string)$value == '') {
                    $value = 'No';
                } elseif ($attribute->getFrontendInput() == 'price' && is_string($value)) {
                    $value = $value;
                }
                if (is_string($value) && strlen($value)) {
                    $data[$attribute->getAttributeCode()] = [
                    'label' => $attribute->getStoreLabel(),
                    'value' => $value,
                    'code'  => $attribute->getAttributeCode(),
                    'type'  => $attribute->getFrontendInput(),
                    'is_required' => $attribute->getIsRequired(),
                    'status' => $adminDefinedAttribute['status']
                    ];
                }
            }
            return $data;
        }
        foreach ($adminDefinedAttributes as $adminDefinedAttribute) {
            $attributeInfoColl = $this->attributeFactory->create()
                ->getCollection()
                ->addFieldToFilter(
                    'attribute_code',
                    ['eq' => $adminDefinedAttribute['attribute_code']]
                );
            foreach ($attributeInfoColl as $attrInfoData) {
                $attribute = $attrInfoData;
            }
            $data[$adminDefinedAttribute['attribute_code']] = [
            'label' =>  $attribute->getStoreLabel(),
            'value' => "",
            'code'  => $attribute->getAttributeCode(),
            'type'  => $attribute->getFrontendInput(),
            'is_required' => $attribute->getIsRequired(),
            'status' => $adminDefinedAttribute['status']
            ];
        }
        return $data;
    }

    /**
     * copyImageToFolder function
     *
     * @param  \Magento\Framework\DataObject $image
     * @return string
     */
    public function copyImageToFolder($image)
    {
        if ($image->getMediaType() == 'image') {
            $file = explode('/', $image->getFile());
        } else {
            return '';
        }
        end($file);
        $key = key($file);
        $fileName = $file[$key];
        $imagePath = $image->getPath();
        $imagesDirectoryPath = $this->directoryList->getPath('media')."/images/";
 
        if (!$this->filesystemFile->fileExists($imagesDirectoryPath)) {
            $this->filesystemFile->mkdir($imagesDirectoryPath, 0777);
        }

        $rfquoteDirectoryPath = $this->directoryList->getPath('media')."/images/requestforquote/";
        
        if (!$this->filesystemFile->fileExists($rfquoteDirectoryPath)) {
            $this->filesystemFile->mkdir($rfquoteDirectoryPath, 0777);
        }
        
        $newPath = $this->directoryList->getPath('media')."/images/requestforquote/";
        $newName  = $newPath.$fileName;
        $copied = $this->filesystemFile->cp($imagePath, $newName);

        if ((!$copied)) {
            return '';
        } else {
            return $fileName;
        }
    }

    public function getRfqHelper()
    {
        return $this->helper;
    }
    
    public function getMpHelper()
    {
        return $this->mpHelper;
    }

    public function getCatalogOutputHelper()
    {
        return $this->catalogOutputHelper;
    }
    
    public function getCatalogImageHelper()
    {
        return $this->catalogImageHelper;
    }

    /**
     * @return the category id
     */
    public function getAttributeIds($productId)
    {
        $product = $this->getProductDetails($productId);
        $categories = $product->getCategoryIds();
        $mappingId = [];
        foreach ($categories as $key => $value) {
            # code...
            $data = $this->categoryAttributeMapping->create()
            ->getCollection()->addFieldTofilter("category_id", ["eq"=>$value])->getData();
            if ($data != null) {
                foreach ($data as $keys => $values) {
                    # code...
                    array_push($mappingId, $values["entity_id"]);
                }
            }
        }
        $groupAttributeId = $this->getAttributeId($mappingId);
        if ($groupAttributeId != null) {
            return $groupAttributeId;
        }
        return [];
    }

    /**
     * @return the  attributes id and groupid
     */
    public function getAttributeId($data)
    {
        $groupAttributeId = [];
        foreach ($data as $key => $value) {
            # code...
            $groupAttributeData = $this->mapGroupAttributeId->create()
            ->getCollection()->addFieldTofilter("mapping_id", ["eq"=>$value])->getData();
            if ($data != null) {
                foreach ($groupAttributeData as $keys => $values) {
                    # code...
                    if (isset($groupAttributeId[$values["attribute_id"]])
                    && $groupAttributeId[$values["attribute_id"]] != null) {
                        $groupAttributeId[$values["attribute_id"]] = $groupAttributeId[$values["attribute_id"]].
                        "-".$values["group_id"];
                    } else {
                        $groupAttributeId[$values["attribute_id"]] = $values["group_id"];
                    }
                }
            }
        }
        return $groupAttributeId;
    }
    /**
     * @return attribute with types
     */
    public function getEavAttributes($productId)
    {
        $attrValueLabel = [];
        $eavAttributeArr = $this->getAttributeIds($productId);
        if ($eavAttributeArr != null) {
            foreach ($eavAttributeArr as $key => $value) {
                # code...
                $eavAttributeObj = $this->eavAttribute->create()->load($key);
                $eavAttributeData = $eavAttributeObj->getData();
                $attrValueLabel[$eavAttributeData["attribute_code"]]["type"] = $eavAttributeData["frontend_input"];
                $attrValueLabel[$eavAttributeData["attribute_code"]]["default"] = $eavAttributeData["default_value"];
                $attrValueLabel[$eavAttributeData["attribute_code"]]["label"] = $eavAttributeData["frontend_label"];
                $attrValueLabel[$eavAttributeData["attribute_code"]]["class"] = $eavAttributeData["frontend_class"];
                $attrValueLabel[$eavAttributeData["attribute_code"]]["options"]=[];
                foreach ($eavAttributeObj->getOptions() as $key => $value) {
                    # code...
                    if ($eavAttributeData["frontend_input"] == 'boolean') {
                        $attrValueLabel[$eavAttributeData["attribute_code"]]
                        ["options"][$value->getValue()] = $value->getLabel();
                    } elseif ($value->getValue() != null) {
                        $attrValueLabel[$eavAttributeData["attribute_code"]]
                        ["options"][$value->getValue()] = $value->getLabel();
                    }
                }
                if ($attrValueLabel[$eavAttributeData["attribute_code"]]["options"] == null
                && $eavAttributeData["attribute_code"] != "cost") {
                        unset($attrValueLabel[$eavAttributeData["attribute_code"]]);
                }
            }
        }
        return $attrValueLabel;
    }
    /**
     * mapping currency update
     *
     * @param array $defaultvalues
     * @param boolean $convert
     * @param boolean $accurate
     * @return void
     */
    public function mappingCurrencyUpdate($defaultvalues, $convert, $accurate)
    {
        return $this->pricingHelper->currency($defaultvalues, $convert, $accurate);
    }
    /**
     * mapping encode
     *
     * @param array $optionData
     * @return void
     */
    public function mappingJsonEncode($optionData)
    {
        return  $this->jsonHelper->jsonEncode($optionData);
    }
}
