<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\App\RequestInterface;

/**
 * AbstractQuotes class
 */
abstract class AbstractQuotes extends \Magento\Customer\Controller\AbstractAccount
{

    /**
     * Check quote exists or not
     *
     * @param  Webkul_Requestforquote_Model_Quote $quote
     * @return bool
     */
    protected function _canViewQuote($quote)
    {
        if ($quote->getId()) {
            return true;
        }
        return false;
    }

    /**
     * Try to load valid quote by quote id
     *
     * @param  int $quoteId
     * @return bool
     */
    protected function _loadValidSellerQuote($mpHelper, $infoModel, $sellerQuoteId = null)
    {
        if (null === $sellerQuoteId) {
            $sellerQuoteId = (int) $this->getRequest()->getParam('id');
        }
        if (!$sellerQuoteId) {
            $this->_forward('noRoute');
            return false;
        }
        $sellerId = $mpHelper->getCustomerId();

        $sellerQuote = $infoModel->create()->load($sellerQuoteId);

        if (($sellerQuote->getSellerId() == $sellerId) && $this->_canViewSellerQuote($sellerQuote)) {
            return true;
        } else {
            $this->_redirect('*/*/list');
        }
        return false;
    }

    /**
     * Check quote exists or not
     *
     * @param  Webkul_Requestforquote_Model_Info $sellerQuote
     * @return bool
     */
    protected function _canViewSellerQuote($sellerQuote)
    {
        if ($sellerQuote->getId()) {
            return true;
        }
        return false;
    }

    /**
     * Try to load valid quote by quote id
     *
     * @param  int $quoteId
     * @return bool
     */
    protected function _loadCustomerValidSellerQuote(
        $sellerQuoteId = null,
        $customerId = null,
        $info = null,
        $mpHelper = null,
        $quote = null
    ) {
        if (null === $sellerQuoteId) {
            $sellerQuoteId = (int) $this->getRequest()->getParam('id');
        }
        if (!$sellerQuoteId) {
            $this->_forward('noRoute');
            return false;
        }

        $sellerQuote = $info->create()->load($sellerQuoteId);

        if ($this->_canCustomerViewSellerQuote($sellerQuote, $mpHelper, $quote)) {
            return true;
        } else {
            $this->_redirect('*/*/list');
        }
        return false;
    }

    /**
     * Check quote exists or not
     *
     * @param  Webkul_Requestforquote_Model_Info $sellerQuote
     * @return bool
     */
    protected function _canCustomerViewSellerQuote($sellerQuote, $mpHelper = null, $quote = null)
    {
        if ($sellerQuote->getId()) {
            $customerId = $mpHelper->getCustomerId();
            $quote = $quote->create()->load($sellerQuote->getQuoteId());
            if ($quote->getCustomerId() == $customerId) {
                return true;
            }
        }
        return false;
    }
}
