<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Account;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Webkul\Requestforquote\Controller\AbstractQuotes;

/**
 * SellerQuoteView class
 */
class QuoteView extends AbstractQuotes
{
    /**
     * @var PageFactory
     */
    private $resultPageFactory;
    
    /**
     * @var \Webkul\Marketplace\Helper\Data
     */
    private $mpHelper;

    /**
     * __construct function
     *
     * @param Context                         $context
     * @param PageFactory                     $resultPageFactory
     * @param \Webkul\Marketplace\Helper\Data $mpHelper
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        \Webkul\Marketplace\Helper\Data $mpHelper
    ) {
    
        $this->resultPageFactory = $resultPageFactory;
        $this->mpHelper = $mpHelper;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
            $resultPage = $this->resultPageFactory->create();
            $customerId = $this->mpHelper->getCustomerId();
            $resultPage->getConfig()->getTitle()->set(__('Requested Quote Details'));
            return $resultPage;
    }
}
