<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Account;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Webkul\Requestforquote\Controller\AbstractQuotes;

class SendMessageToSeller extends AbstractQuotes
{
    /**
     * @var PageFactory
     */
    private $resultPageFactory;
    
    /**
     * @var \Magento\Customer\Model\Session
     */
    private $customerSession;
    
    /**
     * @var \Webkul\Requestforquote\Helper\Data
     */
    private $dataHelper;
    
    /**
     * @var \Webkul\Marketplace\Helper\Data
     */
    private $mpHelper;
    
    /**
     * @var \Webkul\Requestforquote\Model\ConversationFactory
     */
    private $conversation;
    
    /**
     * @var \Webkul\Requestforquote\Model\InfoFactory
     */
    private $info;
    
    /**
     * @var \Webkul\Requestforquote\Model\QuoteFactory
     */
    private $quote;
    
    /**
     * @var \Magento\Customer\Model\CustomerFactory
     */
    private $customer;

    /**
     * __construct
     *
     * @param Context                                           $context
     * @param PageFactory                                       $resultPageFactory
     * @param \Magento\Customer\Model\Session                   $customerSession
     * @param \Webkul\Requestforquote\Helper\Data               $dataHelper
     * @param \Webkul\Marketplace\Helper\Data                   $mpHelper
     * @param \Webkul\Requestforquote\Model\ConversationFactory $conversation
     * @param \Webkul\Requestforquote\Model\InfoFactory         $info
     * @param \Webkul\Requestforquote\Model\QuoteFactory        $quote
     * @param \Magento\Customer\Model\CustomerFactory           $customer
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        \Magento\Customer\Model\Session $customerSession,
        \Webkul\Requestforquote\Helper\Data $dataHelper,
        \Webkul\Marketplace\Helper\Data $mpHelper,
        \Webkul\Requestforquote\Model\ConversationFactory $conversation,
        \Webkul\Requestforquote\Model\InfoFactory $info,
        \Webkul\Requestforquote\Model\QuoteFactory $quote,
        \Magento\Customer\Model\CustomerFactory $customer
    ) {
    
        $this->resultPageFactory = $resultPageFactory;
        $this->customerSession = $customerSession;
        $this->dataHelper = $dataHelper;
        $this->mpHelper = $mpHelper;
        $this->conversation = $conversation;
        $this->info = $info;
        $this->quote = $quote;
        $this->customer = $customer;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        $resultPage = $this->resultPageFactory->create();
        $helper = $this->dataHelper;
        $postData =$this->getRequest()->getParams();
        $sellerQuoteId = $postData['seller_quote_id'];
        $id = $postData['seller_quote_id'];
        try {
            $customerId = $this->mpHelper->getCustomerId();

            if (!$this->_loadCustomerValidSellerQuote(
                $sellerQuoteId,
                $customerId,
                $this->info,
                $this->mpHelper,
                $this->quote
            )
            ) {
                return;
            }
            if (isset($postData['sample_images'])) {
                $postData['sample_images'] = implode(',', $postData['sample_images']);
            }
            $postData['sender_type'] = \Webkul\Requestforquote\Model\Conversation::SENDER_TYPE_CUSTOMER;
            if (isset($postData['approve_last_quote']) && $postData['approve_last_quote'] == 'on') {
                $postData['approved_status'] = 1;
            }
            $modelInfo = $this->conversation->create();
            $modelInfo->setData($postData);
            $modelInfo->save()->getId();

            $sellerQuote = $this->info->create()->load($sellerQuoteId);
            if ($sellerQuote->getStatus() != 3) {
                $sellerQuote->setStatus(1);
                $sellerQuote->setCustomerStatus(2);
                $sellerQuote->save();
            }
            $quoteId = $sellerQuote['quote_id'];

            if (isset($postData['approve_last_quote']) && $postData['approve_last_quote'] == 'on') {
                $lastSellerQuoteId = $this->getSellerLastQuoteId($quoteId, $sellerQuoteId);
                $this->quote->create()->load($quoteId)
                    ->setApprovedSellerQuoteId($lastSellerQuoteId)
                    ->save();
                $requestforquoteInfoColls = $this->info->create()->getCollection()
                    ->addFieldToFilter('quote_id', $quoteId);
                foreach ($requestforquoteInfoColls as $key => $value) {
                    if ($value->getId() == $sellerQuoteId) {
                        $value->setStatus(3);
                        $value->setCustomerStatus(3);
                        $value->save();
                    } else {
                        $value->setStatus(4);
                        $value->setCustomerStatus(4);
                        $value->save();
                    }
                }
            }
            /* Send Quote Mail To Seller */

            $customerId = $this->mpHelper->getCustomerId();
            $customer = $this->customer->create()->load($customerId);

            $quote = $this->quote->create()->load($quoteId);

            $sellerId = $sellerQuote['seller_id'];
            $seller = $this->customer->create()->load($sellerId);

            if ($seller->getId()) {
                /* send mail to seller */
                /* Assign values for your template variables  */
                $emailTempVariables = [];
                $sellerName = $seller->getFirstname()." ".$seller->getLastname();
                $sellerEmail = $seller->getEmail();
                $receiverInfo = [
                    'name' => $sellerName,
                    'email' => $sellerEmail
                ];
                $customerName = $customer->getFirstname()." ".$customer->getLastname();
                $customerEmail = $customer->getEmail();
                $senderInfo = [
                    'name' => $customerName,
                    'email' => $customerEmail
                ];
                $emailTempVariables['name'] = $sellerName;
                $emailTempVariables['subject'] = $quote->getSubject();
                try {
                    $template = \Webkul\Requestforquote\Helper\Data::XML_PATH_REPLY_MAIL_TO_SELLER;
                    $this->dataHelper->customMailSendMethod(
                        $emailTempVariables,
                        $senderInfo,
                        $receiverInfo,
                        $template
                    );
                } catch (\Exception $e) {
                    $this->messageManager->addError($e->getMessage());
                }
            }
            $this->messageManager->addSuccess(__('Message was successfully sent.'));
            $this->_redirect('requestforquote/account/sellerquoteview', ['id' => $id]);
        } catch (\Exception $e) {
            $this->messageManager->addError($e->getMessage());
            $this->_redirect('requestforquote/account/sellerquoteview', ['id' => $id]);
            return;
        }
    }
    
    /**
     * getSellerLastQuoteId get the seller last quoted Id
     *
     * @param  [int] $quoteId
     * @param  [int] $sellerQuoteId
     * @return int
     */
    public function getSellerLastQuoteId($quoteId, $sellerQuoteId)
    {
        $lastSellerQuoteId = 0;
        $requestforquoteInfoColls = $this->conversation->create()->getCollection()
            ->addFieldToFilter('sender_type', 1)
            ->addFieldToFilter('seller_quote_id', $sellerQuoteId)
            ->setOrder('entity_id', 'DESC')
            ->setPageSize(1)
            ->setCurPage(1);
        foreach ($requestforquoteInfoColls as $key => $value) {
            $lastSellerQuoteId = $value->getId();
        }
        return $lastSellerQuoteId;
    }
}
