<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Adminhtml\Index;

use Magento\Framework\Controller\ResultFactory;
use Magento\Backend\App\Action\Context;
use Magento\Ui\Component\MassAction\Filter;
use Webkul\Requestforquote\Model\ResourceModel\Systemattribute\CollectionFactory;

class Massenable extends \Magento\Backend\App\Action
{
    /**
     * @var Filter
     */
    private $filter;

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var integer
     */
    protected $_status = 1;
    
    /**
     * @var integer\Webkul\Requestforquote\Helper\Data
     */
    private $helper;

    /**
     * __construct function
     *
     * @param Context           $context
     * @param Filter            $filter
     * @param CollectionFactory $collectionFactory
     */
    public function __construct(
        Context $context,
        Filter $filter,
        CollectionFactory $collectionFactory,
        \Webkul\Requestforquote\Model\ManageattributeFactory $manageAttribute,
        \Webkul\Requestforquote\Helper\Data $helper
    ) {
        $this->filter = $filter;
        $this->collectionFactory = $collectionFactory;
        $this->manageAttribute = $manageAttribute;
        $this->helper = $helper;
        parent::__construct($context);
    }

    /**
     * Execute action.
     *
     * @return \Magento\Backend\Model\View\Result\Redirect
     *
     * @throws \Magento\Framework\Exception\LocalizedException|\Exception
     */
    public function execute()
    {
        $selected = $this->getRequest()->getParam('selected');
        $excluded = $this->getRequest()->getParam('excluded');
        $ids = [];
        $systemAttributeCollection = $this->collectionFactory->create()->addFieldToFilter('is_user_defined', 1)
            ->addFieldToFilter('entity_type_id', 4)
            ->addFieldToFilter('frontend_input', 'text');
        $collection = $this->filter->getCollection($systemAttributeCollection);
        foreach ($collection as $item) {
            $ids[] = $item->getId();
        }
        if ($excluded == 'false') {
            $excluded = [];
        }
        if (!empty($selected)) {
            $ids = array_intersect($ids, $selected);
        } elseif (!empty($excluded)) {
            $ids = array_diff($ids, $excluded);
        }
        foreach ($ids as $id) {
            $collection = $this->manageAttribute->create()
                ->getCollection()->addFieldToFilter('attribute_id', $id);
            if ($collection->getSize() != 0) {
                foreach ($collection as $row) {
                    $row->setStatus($this->_status);
                    $row->save();
                }
            } else {
                $querydata = $this->manageAttribute->create();
                $data = $this->collectionFactory->create()->addFieldToFilter('attribute_id', ['eq'=>$id]);
                $data = $data->getData();
                $querydata->setAttributeId($id);
                $querydata->setLabel($data[0]['frontend_label']);
                $querydata->setInputType($data[0]['frontend_input']);
                $querydata->setAttributeCode($data[0]['attribute_code']);
                $querydata->setIsRequired($data[0]['is_required']);
                $querydata->setStatus($this->_status);
                $querydata->save();
            }
        }
        $this->helper->clearCache();
        if ($this->_status) {
            $this->messageManager->addSuccess(__('A total of %1 record(s) have been enabled.', count($ids)));
        } else {
            $this->messageManager->addSuccess(__('A total of %1 record(s) have been disabled.', count($ids)));
        }

        /**
         * @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect
        */
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);

        return $resultRedirect->setPath('*/*/');
    }
    /**
     * Check for is allowed.
     *
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Webkul_Requestforquote::index_index');
    }
}
