<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Adminhtml\Mapping;

use Magento\Backend\App\Action;
use Magento\Framework\Controller\ResultFactory;
use Magento\Ui\Component\MassAction\Filter;
use Webkul\Requestforquote\Model\ResourceModel\CategoryAttributeMapping\CollectionFactory;

class Delete extends \Magento\Backend\App\Action
{
    /**
     * @var \Webkul\Requestforquote\Model\MapAttributesToGroupsFactory
     */
    protected $messageManager;
    /**
     * @var \Magento\Catalog\Model\CategoryFactory
     */
    protected $category;
  /**
   * @param \Magento\Backend\App\Action\Context $context
   * @param \Magento\Framework\Registry $registry
   * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
   */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $registry,
        CollectionFactory $categoryAttributeMapping,
        \Webkul\Requestforquote\Api\Data\MapGroupAttributeIdInterfaceFactory $mapGroupAttributeId,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        Filter $filter,
        \Magento\Catalog\Model\CategoryFactory $category
    ) {
        $this->_backendSession = $context->getSession();
        $this->_registry = $registry;
        $this->categoryAttributeMapping = $categoryAttributeMapping;
        $this->mapGroupAttributeId = $mapGroupAttributeId;
        $this->resultPageFactory = $resultPageFactory;
        $this->messageManager = $messageManager;
        $this->_filter = $filter;
        $this->category = $category;
        parent::__construct($context);
    }
    /**
     * Product list page.
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        $mappingIds = [];
        $collection = $this->_filter->getCollection($this->categoryAttributeMapping->create());
        foreach ($collection as $mapping) {
            if ($this->deleteMappingGroup($mapping->getId())) {
                $mappingIds[] = $mapping->getId();
                $this->removeItem($mapping);
            }
        }
        $this->messageManager->addSuccess(__('Mapping(s) deleted succesfully'));
        $resultRedirect = $this->resultRedirectFactory->create();
        return $resultRedirect->setPath('*/*/');
    }
    /**
     * delete submapping
     *
     * @param int $mappingId
     * @return boolean
     */
    protected function deleteMappingGroup($mappingId)
    {
        if ($mappingId) {
            try {
                $groupCollection=$this->mapGroupAttributeId->create();
                $filterGroupColl=$groupCollection->getCollection()
                ->addFieldToFilter('mapping_id', ['eq'=>$mappingId]);
                $filterGroupColl->walk('delete');
                return true;
            } catch (\Exception $e) {
                return false;
            }
        }
        return false;
    }
    /**
     * Remove Item
     *
     * @param object $item
     */
    protected function removeItem($item)
    {
        $item->delete();
    }
}
