<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Adminhtml\Mapping;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Controller\ResultFactory;

class Mapcategoryattribute extends \Magento\Backend\App\Action
{
    /**
     *
     */
    protected $resultFactory;
 
  /**
   * @param \Magento\Backend\App\Action\Context $context
   * @param \Magento\Framework\Registry $registry
   * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
   */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $registry,
        ResultFactory $resultFactory,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory
    ) {
        $this->_backendSession = $context->getSession();
        $this->_registry = $registry;
        $this->resultFactory = $resultFactory;
        $this->resultPageFactory = $resultPageFactory;
        parent::__construct($context);
    }
 
    /**
     * Mapped Grid List page.
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        $rowId = 0;
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $rowId = $this->getRequest()->getParam("id");
        $title = $rowId ? __('Edit Mapping') : __('Add Mapping');
        $resultPage->getConfig()->getTitle()->prepend(__($title));
        return $resultPage;
    }
    
    /**
     * check allowed role
     *
     * @return void
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Webkul_Requestforquote::attributemappingcategory');
    }
}
