<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Adminhtml\Mapping;

use Magento\Backend\App\Action;
use Magento\Framework\Controller\ResultFactory;

class Save extends \Magento\Backend\App\Action
{
 
    /**
     * @var \Webkul\Requestforquote\Model\MapAttributesToGroupsFactory
     */
    protected $messageManager;
    /**
     * @var \Magento\Catalog\Model\CategoryFactory
     */
    protected $category;
  /**
   * @param \Magento\Backend\App\Action\Context $context
   * @param \Magento\Framework\Registry $registry
   * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
   */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $registry,
        \Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterfaceFactory $categoryAttributeMapping,
        \Webkul\Requestforquote\Api\Data\MapGroupAttributeIdInterfaceFactory $mapGroupAttributeId,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Magento\Catalog\Model\CategoryFactory $category
    ) {
        $this->_backendSession = $context->getSession();
        $this->_registry = $registry;
        $this->categoryAttributeMapping = $categoryAttributeMapping;
        $this->mapGroupAttributeId = $mapGroupAttributeId;
        $this->resultPageFactory = $resultPageFactory;
        $this->messageManager = $messageManager;
        $this->category = $category;
        parent::__construct($context);
    }
    /**
     * Product list page.
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        if (!$this->getRequest()->getParams()) {
            $this->messageManager->addError(__("Something went wrong"));
            return $resultRedirect->setPath('*/*/');
        }
        try {
            $attributeGroupId='';
            $attributeIdArray = [];
            $requestParameterArray = $this->getRequest()->getParams();
            $mapCategoryArray  =  $requestParameterArray['requestfirQuote_category_attributes'];
            $attributeSetId  =   $mapCategoryArray['attribute_set_id'];
            $categoryId  =   $mapCategoryArray['category_id'];
            if (isset($requestParameterArray['requestfirQuote_category_attributes'])) {
                if (empty($mapCategoryArray['attribute_set_id']) || empty($attributeSetId)) {
                    $this->messageManager->addError(__("Attribute Set Id is Required."));
                    return $resultRedirect->setPath('*/*/');
                }
                if (empty($mapCategoryArray['category_id']) || empty($categoryId)) {
                    $this->messageManager->addError(__("Category Values are Required."));
                    return $resultRedirect->setPath('*/*/');
                }
                $mappingCollection = $this->getCategoryattributeMap();
                $filterResultCollection = $mappingCollection->getCollection()
                ->addFieldToFilter('attribute_set_id', ['eq'=>$attributeSetId])
                ->addFieldToFilter('category_id', ['eq'=>$categoryId]);
                $filterResultCollection->setPageSize(1, 1);
                if ($filterResultCollection->getSize()>0) {
                    $mappingId = $filterResultCollection->getLastItem()->getEntityId();
                    $mapCategoryArray["entity_id"] = $mappingId;
                    $attributeGroups = $requestParameterArray['attribute_groups'];
                    if (isset($requestParameterArray['attribute_groups'])) {
                        $result = $this->saveMappingCollectiveData(
                            $mapCategoryArray,
                            $categoryId,
                            $attributeSetId,
                            $attributeGroups
                        );
                        if ($result == 1) {
                            $this->messageManager->addSuccess(__("Attributes Groups Successfully Saved"));
                        } else {
                            $this->messageManager->addError(__("Something went wrong"));
                            return $resultRedirect->setPath('*/*/');
                        }
                    } else {
                        $this->messageManager->addError(__("Please select the attribute groups"));
                        return $resultRedirect->setPath('*/*/');
                    }
                } else {
                    if (isset($requestParameterArray['attribute_groups'])) {
                        $attributeGroups = $requestParameterArray['attribute_groups'];
                        $result = $this->saveMappingCollectiveData(
                            $mapCategoryArray,
                            $categoryId,
                            $attributeSetId,
                            $attributeGroups
                        );
                        if ($result == 1) {
                            $this->messageManager->addSuccess(__("Attributes Groups Successfully Saved"));
                        } else {
                            $this->messageManager->addError(__("Something went wrong"));
                            return $resultRedirect->setPath('*/*/');
                        }
                    } else {
                        $this->messageManager->addError(__("Please select the attribute groups"));
                        return $resultRedirect->setPath('*/*/');
                    }
                }
            }
             return $resultRedirect->setPath('*/*/');
        } catch (\Exception $e) {
            $this->messageManager->addError(__("Something went wrong"));
            return $resultRedirect->setPath('*/*/');
        }
    }
    /**
     * @return categoryAttributeMapping object
     */
    public function getCategoryattributeMap()
    {
        return $this->categoryAttributeMapping->create();
    }
    /**
     * @return mapGroupAttributeId onject
     */
    public function getMapGroupAttributeId()
    {
        return $this->mapGroupAttributeId->create();
    }
    /**
     * save the category mapping data to attribute
     */
    public function saveMappingCollectiveData($mapCategoryArray, $categoryId, $attributeSetId, $attributeGroups)
    {
        $mappingId = 0;
        if ($categoryId == null || $attributeSetId == null) {
              return null;
        }
        if ($mapCategoryArray != null) {
            $getCategoryattributeMap = $this->getCategoryattributeMap();
            $categoryPath = $this->getCategoryPath($categoryId);
            if (isset($mapCategoryArray["entity_id"])) {
                $getCategoryattributeMap->setId($mapCategoryArray["entity_id"]);
            }
            $getCategoryattributeMap->setAttributeSetId($attributeSetId);
            $getCategoryattributeMap->setCategoryId($categoryId);
            $getCategoryattributeMap->setCategoryPath($categoryPath);
            $getCategoryattributeMap->save();
            $mappingId = $getCategoryattributeMap->getId();
        }
        if (isset($mapCategoryArray["entity_id"])) {
            $value = $this->deleteGroupAttribute($mapCategoryArray["entity_id"]);
            $result = $this->saveAttributeGroups($attributeGroups, $mapCategoryArray["entity_id"]);
        } else {
            $result = $this->saveAttributeGroups($attributeGroups, $mappingId);
        }
        return $result;
    }
    /**
     * @return path of the category
     */
    public function getCategoryPath($categoryId)
    {
        $category = $this->getCategory();
        if ($categoryId) {
            $path = $category->load($categoryId)->getPathIds();
            return implode(",", $path);
        }
        return $categoryId;
    }
    /**
     * @return the fresh object of category
     */
    public function getCategory()
    {
        return $this->category->create();
    }
    /**
     * save the attribute groups
     */
    public function saveAttributeGroups($attributeGroups, $mappingId)
    {
        $result = 0;
        if ($mappingId != null) {
            foreach ($attributeGroups as $key => $value) {
                # code...
                $getMapGroupAttributeId = $this->getMapGroupAttributeId();
                $explodedData = explode("-", $value);
                $attributeGroupId = $explodedData[0];
                $attributeId = $explodedData[1];
                $getMapGroupAttributeId->setMappingId($mappingId);
                $getMapGroupAttributeId->setGroupId($attributeGroupId);
                $getMapGroupAttributeId->setAttributeId($attributeId);
                $getMapGroupAttributeId->save();
                $result = 1;
            }
        }
        return $result;
    }
    /**
     * @return 1 after deletion for updation on delete attribute group
     */
    public function deleteGroupAttribute($mappingId)
    {
        $result = 0 ;
        if ($mappingId != null) {
            $getMapGroupAttributeId = $this->getMapGroupAttributeId()->getCollection()
                                     ->addFieldToFilter("mapping_id", ["eq"=>$mappingId]);
            $getMapGroupAttributeId->walk('delete');
            $result = 1;
        }
        return $result;
    }
}
