<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Customer;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\App\RequestInterface;

class AddToCart extends \Magento\Customer\Controller\AbstractAccount
{
    /**
     * @var \Magento\Framework\Data\Form\FormKey
     */
    private $formKey;
    
    /**
     * @var \Magento\Checkout\Model\Cart
     */
    private $cart;
    
    /**
     * @var \Magento\Catalog\Model\Product
     */
    private $product;
    
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $url;
    
    /**
     * @var \Webkul\Requestforquote\Helper\Data
     */
    private $dataHelper;
    
    /**
     * @var \Magento\Framework\Controller\Result\JsonFactory
     */
    private $jsonResultFactory;
    
    /**
     * @var PageFactory
     */
    private $resultPageFactory;
    
    /**
     * __construct function
     *
     * @param Context                                          $context
     * @param \Magento\Framework\Controller\Result\JsonFactory $jsonResultFactory
     * @param \Magento\Framework\Data\Form\FormKey             $formKey
     * @param \Magento\Checkout\Model\Cart                     $cart
     * @param \Magento\Catalog\Model\Product                   $product
     * @param \Webkul\Requestforquote\Helper\Data              $dataHelper
     * @param array                                            $data
     */
    public function __construct(
        Context $context,
        \Magento\Framework\Controller\Result\JsonFactory $jsonResultFactory,
        \Magento\Framework\Data\Form\FormKey $formKey,
        \Magento\Checkout\Model\Cart $cart,
        \Magento\Catalog\Model\Product $product,
        \Webkul\Requestforquote\Helper\Data $dataHelper,
        array $data = []
    ) {
    
        $this->formKey = $formKey;
        $this->cart = $cart;
        $this->product = $product;
        $this->jsonResultFactory = $jsonResultFactory;
        $this->url = $context->getUrl();
        $this->dataHelper = $dataHelper;
        parent::__construct($context);
    }

    /**
     * Check customer is logged in or not ?
     *
     * @param  RequestInterface $request
     * @return \Magento\Framework\App\ResponseInterface
     */
    public function dispatch(RequestInterface $request)
    {
        if (!$this->dataHelper->getStatusOfModuleFromConfig()) {
            $this
                ->resultFactory
                ->create('forward')
                ->forward('noroute');
        }
        return parent::dispatch($request);
    }
    
    public function execute()
    {
        $result = $this->jsonResultFactory->create();
        $post = $this->getRequest()->getParams();
        $cart = $this->cart->getItems();
        $itemId = 0;
        if (!empty($cart)) {
            foreach ($cart as $cartItem) {
                $infoBuyRequuest = $cartItem->getBuyRequest();
                if (isset($infoBuyRequuest['quoteInfoId'])) {
                    if ($infoBuyRequuest['quoteInfoId'] == $post['quoteInfoId']) {
                        $this->messageManager->addWarning(__("item already added to the cart"));
                        return $result->setData(['error' => true,'message'=>__("item already added to the cart")]);
                    }
                }
            }
        }
        try {
            $params = [
                'form_key' => $this->formKey->getFormKey(),
                'product' => $post['productId'],
                'qty'   =>$post['quantity'],
                'quoteInfoId' => $post['quoteInfoId'],
                'price'=> $post['price']
            ];
            $request = new \Magento\Framework\DataObject();
            $request->setData($params);
            $product = $this->product->load($post['productId']);
            $this->cart->addProduct($product, $request);
            $this->cart->save();
            $cartUrl = $this->url->getUrl('checkout/cart/index');
            $this->messageManager->addSuccess(__("quote product successfully added to the cart"));
            return $result->setData(
                [
                    'success' => true,
                    'Url'=> $cartUrl,
                    'message'=> __('quote product successfully added to the cart')
                ]
            );
        } catch (\Exception $e) {
            $this->messageManager->addError(_($e->getMessage()));
            return $result->setData(['error' => true,'message'=>$e->getMessage()]);
        }
        return $result;
    }
}
