<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Index;

use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\App\RequestInterface;

class Index extends \Magento\Customer\Controller\AbstractAccount
{
    /**
     * @var PageFactory
     */
    private $resultPageFactory;
    
    /**
     * @var \Webkul\Requestforquote\Helper\Data
     */
    private $helper;
    
    /**
     * @var \Magento\Customer\Model\CustomerFactory
     */
    private $customerFactory;

    /**
     * __construct function
     *
     * @param Context                                 $context
     * @param PageFactory                             $resultPageFactory
     * @param \Webkul\Requestforquote\Helper\Data     $dataHelper
     * @param \Magento\Customer\Model\CustomerFactory $customerFactory
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        \Webkul\Requestforquote\Helper\Data $dataHelper,
        \Magento\Customer\Model\CustomerFactory $customerFactory
    ) {
    
        $this->resultPageFactory = $resultPageFactory;
        $this->helper = $dataHelper;
        $this->customerFactory = $customerFactory;
        parent::__construct($context);
    }

    /**
     * Check customer is logged in or not ?
     *
     * @param  RequestInterface $request
     * @return \Magento\Framework\App\ResponseInterface
     */
    public function dispatch(RequestInterface $request)
    {
        if (!$this->helper->getStatusOfModuleFromConfig()) {
            $this
                ->resultFactory
                ->create('forward')
                ->forward('noroute');
        }
        return parent::dispatch($request);
    }
    
    /**
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        $resultPage = $this->resultPageFactory->create();
        $resultPage->getConfig()->getTitle()->set(__('Request For Quote'));
        return $resultPage;
    }
}
