<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Index;

use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;

class Post extends Action
{
    /**
     * @var PageFactory
     */
    private $resultPageFactory;

    /**
     * @var \Magento\Framework\Session\SessionManagerInterface
     */
    private $session;

    /**
     * __construct function
     *
     * @param Context                                            $context
     * @param PageFactory                                        $resultPageFactory
     * @param \Magento\Framework\Session\SessionManagerInterface $session
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        \Magento\Framework\Session\SessionManagerInterface $session
    ) {

        $this->resultPageFactory = $resultPageFactory;
        $this->session = $session;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        $postData = $this->getRequest()->getParams();
        $postData['attribute_description'] = "";
        $attributeDescription = "";
        $superAttributeDescription = "";
        if (isset($postData['atr']) && !empty($postData['atr'])) {
            $attributeDescription = $attributeDescription .
                    '<table class="data-table"><col width="25%" /><col /><tbody>';
            foreach ($postData['atr'] as $key => $val):
                $split = explode('_', $key);
                $type = end($split);
                $label = explode('_'.$type, $key);
                $label = implode(' ', explode('_', $label[0]));
                $attributeDescription = $attributeDescription .
                '<tr><th class="label">' .$label.
                '</th><td class="data"><input class="wk_req_admin_defined_attribute_input" name="'.$type.
                '" type="'.$split[1].'" value="'.$val.'"><span class="wk_req_admin_defined_attribute_span_text">'
                .$val.'</span></td></tr>';
            endforeach;
                
        }
        $attributeDescription = $attributeDescription . '</tbody></table><br/>';
        $superAttributeDescription = $superAttributeDescription .
                    '<table class="data-table"><col width="25%" /><col /><tbody>';
                    $superAttributeDescription = $superAttributeDescription .
                    '<tr><th class="label">' .__("Attributes ").'</th>'.
                    '<th class="label">' .__("Attributes Description").'</th><tr>';
        foreach ($postData as $key => &$value) {
            # code...
            if (explode("-", $key)[0] == "super_attribute") {
                if (isset($value) && is_array($value)) {
                    $superAttributeDescription = $superAttributeDescription .'<tr><th class="label">'
                    .explode("-", $key)[1].
                        '</th><td class="data">'.implode(", ", $value).'</td></tr>';
                } else {
                    $superAttributeDescription = $superAttributeDescription .'<tr><th class="label">'
                    .explode("-", $key)[1].'</th><td class="data">'.$value. '</td></tr>';
                }
            }
        }
        $superAttributeDescription = $superAttributeDescription . '</tbody></table><br/>';
        $attributeDescription = $attributeDescription.$superAttributeDescription;
        $postData['attribute_description'] = $attributeDescription;
        $this->session->setRequestForQuoteFormData($postData);
        $this->_redirect('requestforquote/account/post');
    }
}
