<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Index;

use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\View\Asset\Repository;

class SampleUpload extends Action
{
    /**
     * @var PageFactory
     */
    private $resultPageFactory;

    /**
     * @var \Magento\Framework\Filesystem
     */
    private $filesystem;

    /**
     * @var \Magento\MediaStorage\Model\File\UploaderFactory
     */
    private $fileUploaderFactory;

    /**
     * @var \Webkul\Requestforquote\Helper\Data
     */
    private $helper;

    /**
     * __construct function
     *
     * @param Context                                          $context
     * @param PageFactory                                      $resultPageFactory
     * @param \Magento\Framework\Filesystem                    $filesystem
     * @param \Magento\MediaStorage\Model\File\UploaderFactory $fileUploaderFactory
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        \Magento\Framework\Filesystem $filesystem,
        Repository $assetRepo,
        \Magento\MediaStorage\Model\File\UploaderFactory $fileUploaderFactory,
        \Webkul\Requestforquote\Helper\Data $helper
    ) {
        $this->assetRepo = $assetRepo;
        $this->resultPageFactory = $resultPageFactory;
        $this->filesystem = $filesystem;
        $this->fileUploaderFactory = $fileUploaderFactory;
        $this->helper = $helper;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        $imageData = $this->getRequest()->getFiles();
        try {
            $newImageFlag = 0;
            $error =__("There was an error in uploading the file.");
            if (strlen($imageData['sample_images']['name'])>0) {
                $uploader = $this->fileUploaderFactory->create(['fileId' => 'sample_images']);
                $uploader->setAllowedExtensions(explode(',', $this->helper->getAllowedExt()));
                $uploader->setAllowRenameFiles(false);
                $uploader->setFilesDispersion(false);
                $path = $this->filesystem->getDirectoryRead(DirectoryList::MEDIA)
                    ->getAbsolutePath('images/requestforquote');
                $saved = $uploader->save($path);
                if ($saved) {
                    $currentStore = $this->helper->getStore();
                    $mediaUrl = $currentStore->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
                    $newImageFlag = 1;
                    $finalName = $saved['file'];
                    $finalUrl =  $mediaUrl."images/requestforquote/".$saved['file'];
                    $type =  $saved['type'];
                    $params = ['_secure' => $this->getRequest()->isSecure()];
                    if (strpos($type, 'pdf') !== false) {
                        $finalUrl = $this->assetRepo
                            ->getUrlWithParams('Webkul_Requestforquote::images/pdf.jpeg', $params);
                    } elseif (strpos($type, 'doc') !== false ||
                        strpos($type, 'msword') !== false ||
                        strpos($type, 'text') !== false
                        ) {
                        $finalUrl = $this->assetRepo
                            ->getUrlWithParams('Webkul_Requestforquote::images/doc.jpeg', $params);
                    } elseif (strpos($type, 'excel') !== false || strpos($type, 'csv') !== false) {
                        $finalUrl = $this->assetRepo
                            ->getUrlWithParams('Webkul_Requestforquote::images/excel.png', $params);
                    }
                }
            }
            if ($newImageFlag == 1) {
                $this->getResponse()->setHeader('Content-type', 'text/html');
                $this->getResponse()->setBody(
                    $this->helper->jsonEncoder(
                        ["type"=>$type, "fileurl"=>$finalUrl, "filename"=>$finalName]
                    )
                );
            } else {
                $this->getResponse()->setHeader('Content-type', 'text/html');
                $this->getResponse()->setBody($this->helper->jsonEncoder(["type"=>'', "errormsg"=>$error]));
            }
        } catch (\Exception $e) {
            $this->getResponse()->setHeader('Content-type', 'text/html');
            $this->getResponse()->setBody(
                $this->helper->jsonEncoder(
                    [
                    "type"=>'',
                    "errormsg"=>__("There was an error in uploading the file.").$e->getMessage()
                    ]
                )
            );
        }
    }
}
