<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Quote;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Webkul\Requestforquote\Controller\AbstractQuotes;

class SendMessageToCustomer extends AbstractQuotes
{
    /**
     * @var PageFactory
     */
    private $resultPageFactory;
    
    /**
     * @var \Magento\Framework\Json\Helper\Data
     */
    private $json;
    
    /**
     * @var \Webkul\Requestforquote\Helper\Data
     */
    private $dataHelper;
    
    /**
     * @var \Webkul\Requestforquote\Model\ConversationFactory
     */
    private $conversation;
    
    /**
     * @var \Webkul\Requestforquote\Model\InfoFactory
     */
    private $info;
    
    /**
     * @var \Webkul\Requestforquote\Model\QuoteFactory
     */
    private $quote;
    
    /**
     * @var \Magento\Customer\Model\Customer
     */
    private $customer;
    
    /**
     * @var \Webkul\Marketplace\Helper\Data
     */
    private $mpHelper;

    /**
     * __construct
     *
     * @param Context                                           $context
     * @param PageFactory                                       $resultPageFactory
     * @param \Magento\Framework\Json\Helper\Data               $jsonHelper
     * @param \Webkul\Requestforquote\Helper\Data               $dataHelper
     * @param \Webkul\Requestforquote\Model\ConversationFactory $conversation
     * @param \Webkul\Requestforquote\Model\InfoFactory         $info
     * @param \Webkul\Requestforquote\Model\QuoteFactory        $quote
     * @param \Magento\Customer\Model\Customer                  $customer
     * @param \Webkul\Marketplace\Helper\Data                   $mpHelper
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        \Webkul\Requestforquote\Helper\Data $dataHelper,
        \Webkul\Requestforquote\Model\ConversationFactory $conversation,
        \Webkul\Requestforquote\Model\InfoFactory $info,
        \Webkul\Requestforquote\Model\QuoteFactory $quote,
        \Magento\Customer\Model\Customer $customer,
        \Webkul\Marketplace\Helper\Data $mpHelper
    ) {
    
        $this->resultPageFactory = $resultPageFactory;
        $this->json = $jsonHelper;
        $this->dataHelper = $dataHelper;
        $this->conversation = $conversation;
        $this->info = $info;
        $this->quote = $quote;
        $this->customer = $customer;
        $this->mpHelper = $mpHelper;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        $resultPage = $this->resultPageFactory->create();
        $helper = $this->dataHelper;
        $postData =$this->getRequest()->getParams();
        $sellerQuoteId = $postData['seller_quote_id'];
        $id = $postData['seller_quote_id'];
        try {
            $isPartner= $this->mpHelper->isSeller();
            if ($isPartner != 1) {
                $this->_forward('noRoute');
                return;
            }
            if (!$this->_loadValidSellerQuote($this->mpHelper, $this->info, $sellerQuoteId)) {
                return;
            }
            if (isset($postData['sample_images'])) {
                $postData['sample_images'] = implode(',', $postData['sample_images']);
            }
            $sellerId = $this->mpHelper->getCustomerId();
            $postData['seller_id'] = $sellerId;
            $seller = $this->customer->load($sellerId);
            $sellerId = $seller->getId();
            $sellerName = $seller->getFirstname()." ".$seller->getLastname();
            $sellerEmail = $seller->getEmail();
            $senderInfo = [
                'name' => $sellerName,
                'email' => $sellerEmail
            ];
            $postData['sender_type'] = \Webkul\Requestforquote\Model\Conversation::SENDER_TYPE_SELLER;
            $modelInfo = $this->conversation->create();
            $modelInfo->setData($postData);
            $modelInfo->save();

            $sellerQuote = $this->info->create()->load($sellerQuoteId);
            if ($sellerQuote->getCustomerStatus() != 3 && $sellerQuote->getStatus() != 3) {
                $sellerQuote->setStatus(2);
                $sellerQuote->setCustomerStatus(1);
                $sellerQuote->save();
            }
            $quoteId = $sellerQuote['quote_id'];
            $quote = $this->quote->create()->load($quoteId);
            $customerId = $quote['customer_id'];
            /* Send Quote Mail To Customer */
            $customer = $this->customer->load($customerId);
            if ($sellerId) {
                /* send mail to seller */
                /* Assign values for your template variables  */
                $emailTempVariables = [];
                $customerName = $customer->getFirstname()." ".$customer->getLastname();
                $customerEmail = $customer->getEmail();
                $receiverInfo = [
                    'name' => $customerName,
                    'email' => $customerEmail
                ];
                $emailTempVariables['name'] = $customerName;
                $emailTempVariables['subject'] = $postData['response'];
                if (isset($postData['bulk_quote_qty']) && isset($postData['quote_price'])) {
                    $emailTempVariables['quantity'] = $postData['bulk_quote_qty'];
                    $emailTempVariables['price'] = $postData['quote_price'];
                }
                try {
                    $template = \Webkul\Requestforquote\Helper\Data::XML_PATH_REPLY_MAIL_TO_CUSTOMER;
                    $this->dataHelper->customMailSendMethod(
                        $emailTempVariables,
                        $senderInfo,
                        $receiverInfo,
                        $template
                    );
                } catch (\Exception $e) {
                    $this->messageManager->addError($e->getMessage());
                }
            }
            $this->messageManager->addSuccess(__('Message was successfully send.'));
            $this->_redirect('requestforquote/seller/view', ['id' => $id]);
        } catch (\Exception $e) {
            $this->messageManager->addError($e->getMessage());
            $this->_redirect('requestforquote/seller/view', ['id' => $id]);
            return;
        }
    }
}
