<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Seller;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\App\RequestInterface;
use Webkul\Marketplace\Controller\Product\SaveProduct;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Filesystem\Io\File;

class CreateNewProduct extends \Magento\Customer\Controller\AbstractAccount
{
    /**
     * @var \Magento\Framework\Controller\Result\JsonFactory
     */
    private $jsonResultFactory;

    /**
     * @var \Magento\Framework\Stdlib\DateTime\DateTime
     */
    private $date;

    /**
     * @var \Webkul\Requestforquote\Helper\Data
     */
    private $dataHelper;

    /**
     * @var \Webkul\Marketplace\Helper\Data
     */
    private $marketplaceHelper;

    /**
     * @var \Webkul\Requestforquote\Model\QuoteFactory
     */
    private $quote;

    /**
     * @var \Webkul\Requestforquote\Model\InfoFactory
     */
    private $info;

    /**
     * @var \Magento\Catalog\Api\Data\ProductInterfaceFactory
     */
    private $productFactory;

    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    private $productRepository;

    /**
     * @var \Magento\UrlRewrite\Model\ResourceModel\UrlRewriteCollectionFactory
     */
    private $urlRewrite;

    /**
     * @var \Magento\Framework\App\Filesystem\DirectoryList
     */
    private $directory_list;

    /**
     * @var SaveProductt
     */
    private $saveProduct;

    /**
     * Constructor
     *
     * @param Context                                                             $context
     * @param \Magento\Framework\Controller\Result\JsonFactory                    $jsonResultFactory
     * @param \Magento\Framework\Stdlib\DateTime\DateTime                         $date
     * @param \Webkul\Requestforquote\Helper\Data                                 $dataHelper
     * @param \Webkul\Marketplace\Helper\Data                                     $marketplaceHelper
     * @param \Webkul\Requestforquote\Model\QuoteFactory                          $quote
     * @param \Webkul\Requestforquote\Model\InfoFactory                           $info
     * @param \Magento\Catalog\Api\Data\ProductInterfaceFactory                   $productFactory
     * @param \Magento\Catalog\Api\ProductRepositoryInterface                     $productRepository
     * @param \Magento\Framework\App\Filesystem\DirectoryList                     $directory_list
     * @param \Magento\UrlRewrite\Model\ResourceModel\UrlRewriteCollectionFactory $urlRewrite
     * @param SaveProduct                                                         $saveProduct
     */
    public function __construct(
        Context $context,
        \Magento\Framework\Controller\Result\JsonFactory $jsonResultFactory,
        \Magento\Framework\Stdlib\DateTime\DateTime $date,
        \Webkul\Requestforquote\Helper\Data $dataHelper,
        \Webkul\Marketplace\Helper\Data $marketplaceHelper,
        \Webkul\Requestforquote\Model\QuoteFactory $quote,
        \Webkul\Requestforquote\Model\InfoFactory $info,
        \Magento\Catalog\Api\Data\ProductInterfaceFactory $productFactory,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        \Magento\Framework\App\Filesystem\DirectoryList $directory_list,
        \Magento\UrlRewrite\Model\ResourceModel\UrlRewriteCollectionFactory $urlRewrite,
        SaveProduct $saveProduct,
        File $file
    ) {
        $this->jsonResultFactory = $jsonResultFactory;
        $this->date = $date;
        $this->dataHelper = $dataHelper;
        $this->marketplaceHelper = $marketplaceHelper;
        $this->quote = $quote;
        $this->info = $info;
        $this->productFactory = $productFactory;
        $this->productRepository = $productRepository;
        $this->urlRewrite = $urlRewrite;
        $this->saveProduct = $saveProduct;
        parent::__construct($context);
        $this->directory_list = $directory_list;
        $this->file = $file;
    }

    /**
     * Check customer is logged in or not ?
     *
     * @param  RequestInterface $request
     * @return \Magento\Framework\App\ResponseInterface
     */
    public function dispatch(RequestInterface $request)
    {
        if (!$this->dataHelper->getStatusOfModuleFromConfig()) {
            $this
                ->resultFactory
                ->create('forward')
                ->forward('noroute');
        }
        return parent::dispatch($request);
    }

    /**
     * @return \Magento\Framework\Controller\Result\JsonFactory
     */
    public function execute()
    {
        $result = $this->jsonResultFactory->create();
        $post = $this->getRequest()->getparams();
        $imagePath = "";
        $sampleImages = [];
        $quote = $this->quote->create()->load($post['quoteId']);
        if ($quote['sample_images']) {
            $sampleImages =  explode(',', $quote['sample_images']);
        }
        if (!empty($sampleImages)) {
            foreach ($sampleImages as $sampleImage) {
                $ext = $this->file->getPathInfo($sampleImage);
                if ($ext != 'pdf' && $ext != 'doc') {
                    $imagePath = $this->directory_list->getPath('media')."/images/requestforquote/".$sampleImage;
                    break;
                }
            }
            
        }
        $urlKey = preg_replace('/\s+/', '-', $quote->getSubject());
        $urlKey = $urlKey."-".$quote->getEntityId();
        $createdUrl = $this->createUrl($urlKey, $urlKey, 0);
        try {
             $product = [];
             $product['name'] = $quote->getSubject();
             $product['sku'] = $quote->getSubject()."-".$quote->getEntityId();
            if (strlen($product['sku']) > 64) {
                $product['sku'] = $this->date->gmtDate()."-".$quote->getEntityId();
            }
            $product['price'] = $post['price'];
            $product['url_key'] = $createdUrl;
            $product['stock_data'] = [
                'manage_stock'=>1,
                'use_config_manage_stock'=>1,
                'min_sale_qty'=>$post['quantity'],
                'max_sale_qty' => $post['quantity']
            ];
            $product['quantity_and_stock_status'] = ['qty'=>$post['quantity'],'is_in_stock'=>1];
            $product['visibility'] = 1;
            $product['tax_class_id'] = $post['taxClassId'];
            $product['product_has_weight'] = ($quote->getProductWeight() > 0)?1:0;
            $product['weight'] = $quote->getProductWeight();
            $wholeData = [];
            $wholeData['type'] = \Webkul\Requestforquote\Model\Product\Type\Quote::TYPE_ID;
            $wholeData['set'] = 4;
            $wholeData['status'] = 1;
            $wholeData['product'] = $product;
            $returnArr = $this->saveProduct->saveProductData(
                $this->marketplaceHelper->getCustomerId(),
                $wholeData
            );
            if ($returnArr['error'] == 0) {
                $newProductId = $returnArr['product_id'];
            } else {
                throw new LocalizedException(
                    __(
                        "Product Type or Attribute Set Invalid Or Not Allowed From Marketplace Configuration"
                    )
                );
            }
            $productModel= $this->productFactory->create()->load($newProductId);
            if ($imagePath!="") {
                $productModel->addImageToMediaGallery($imagePath, ['image', 'small_image', 'thumbnail'], false, true);
                $productModel->save();
            }
            $infoModel = $this->info->create()->load($post['quoteInfoId']);
            $infoModel->setProductCreated(1);
            $infoModel->save();

            $quoteModel = $this->quote->create()->load($post['quoteId']);
            $quoteModel->setProductId($newProductId);
            $quoteModel->save();
            $message = __("You created a product name %1 of type quote in to your account.", $quote->getSubject());
            return $result->setData(['success' => true, 'message'=> $message]);
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
            return $result->setData(['error' => true, 'message'=> $e->getMessage()]);
        }
    }

    /**
     * createUrl function create and check the duplicacy of url
     *
     * @param  String  $url
     * @param  String  $mainUrl
     * @param  integer $i
     * @return String
     */
    public function createUrl($url, $mainUrl, $i = 0)
    {
        $urlRewriteCollection = $this->urlRewrite->create();
        $urlRewriteCollection->addFieldToFilter('entity_type', ['eq'=>'product'])
            ->addFieldToFilter('store_id', ['eq'=>1])
            ->addFieldToFilter('request_path', ['eq'=>$url.".html"]);
        if ($urlRewriteCollection->getSize()== 0) {
            return $url;
        }
        $url = $mainUrl;
        $i++;
        $url = $url."-".$i;
        $url = $this->createUrl($url, $mainUrl, $i);
        return $url;
    }
}
