<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Controller\Seller;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Webkul\Requestforquote\Controller\AbstractQuotes;
use Magento\Framework\App\RequestInterface;

class View extends AbstractQuotes
{
    /**
     * @var PageFactory
     */
    private $resultPageFactory;

    /**
     * @var \Webkul\Requestforquote\Helper\Data
     */
    private $dataHelper;
    
    /**
     * @var \Webkul\Marketplace\Helper\Data
     */
    private $mpHelper;
        
    /**
     * __construct function
     *
     * @param Context                             $context
     * @param PageFactory                         $resultPageFactory
     * @param \Webkul\Requestforquote\Helper\Data $dataHelper
     * @param \Webkul\Marketplace\Helper\Data     $mpHelper
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        \Webkul\Requestforquote\Helper\Data $dataHelper,
        \Webkul\Marketplace\Helper\Data $mpHelper
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->dataHelper = $dataHelper;
        $this->mpHelper = $mpHelper;
        parent::__construct($context);
    }

    public function dispatch(RequestInterface $request)
    {
        if (!$this->dataHelper->getStatusOfModuleFromConfig()) {
            $this
                ->resultFactory
                ->create('forward')
                ->forward('noroute');
        }
        return parent::dispatch($request);
    }
    
    /**
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        $helper = $this->mpHelper;
        $isPartner = $helper->isSeller();
        if ($isPartner == 1) {
            $resultPage = $this->resultPageFactory->create();
            if ($this->mpHelper->getIsSeparatePanel()) {
                $resultPage->addHandle('requestforquote_seller_view_layout2');
            }
            $resultPage = $this->resultPageFactory->create();
            $resultPage->getConfig()->getTitle()->set(__('Requested Quote Details'));
            return $resultPage;
        } else {
            return $this->resultRedirectFactory->create()->setPath(
                'marketplace/account/becomeseller',
                ['_secure' => $this->getRequest()->isSecure()]
            );
        }
    }
}
