<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Requestforquote
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */


namespace Webkul\Requestforquote\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\DataObject\IdentityInterface;
use Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterface;

class CategoryAttributeMapping extends AbstractModel implements IdentityInterface, CategoryAttributeMappingInterface
{

    const NOROUTE_ENTITY_ID = 'no-route';

    const CACHE_TAG = 'webkul_requestforquote_categoryattributemapping';

    protected $_cacheTag = 'webkul_requestforquote_categoryattributemapping';

    protected $_eventPrefix = 'webkul_requestforquote_categoryattributemapping';

    /**
     * set resource model
     */
    public function _construct()
    {
        $this->_init(\Webkul\Requestforquote\Model\ResourceModel\CategoryAttributeMapping::class);
    }

    /**
     * Load No-Route Indexer.
     *
     * @return $this
     */
    public function noRouteReasons()
    {
        return $this->load(self::NOROUTE_ENTITY_ID, $this->getIdFieldName());
    }

    /**
     * Get identities.
     *
     * @return []
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG.'_'.$this->getId()];
    }

    /**
     * Set EntityId
     *
     * @param int $entityId
     * @return Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterface
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * Get EntityId
     *
     * @return int
     */
    public function getEntityId()
    {
        return parent::getData(self::ENTITY_ID);
    }

    /**
     * Set AttributeSetId
     *
     * @param int $attributeSetId
     * @return Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterface
     */
    public function setAttributeSetId($attributeSetId)
    {
        return $this->setData(self::ATTRIBUTE_SET_ID, $attributeSetId);
    }

    /**
     * Get AttributeSetId
     *
     * @return int
     */
    public function getAttributeSetId()
    {
        return parent::getData(self::ATTRIBUTE_SET_ID);
    }

    /**
     * Set CategoryId
     *
     * @param int $categoryId
     * @return Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterface
     */
    public function setCategoryId($categoryId)
    {
        return $this->setData(self::CATEGORY_ID, $categoryId);
    }

    /**
     * Get CategoryId
     *
     * @return int
     */
    public function getCategoryId()
    {
        return parent::getData(self::CATEGORY_ID);
    }

    /**
     * Set CategoryPath
     *
     * @param string $categoryPath
     * @return Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterface
     */
    public function setCategoryPath($categoryPath)
    {
        return $this->setData(self::CATEGORY_PATH, $categoryPath);
    }

    /**
     * Get CategoryPath
     *
     * @return string
     */
    public function getCategoryPath()
    {
        return parent::getData(self::CATEGORY_PATH);
    }
}
