<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Requestforquote
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */


namespace Webkul\Requestforquote\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\DataObject\IdentityInterface;
use Webkul\Requestforquote\Api\Data\ConversationInterface;

class Conversation extends AbstractModel implements IdentityInterface, ConversationInterface
{

    const NOROUTE_ENTITY_ID = 'no-route';

    const CACHE_TAG = 'webkul_requestforquote_conversation';

    protected $_cacheTag = 'webkul_requestforquote_conversation';

    protected $_eventPrefix = 'webkul_requestforquote_conversation';

    const SENDER_TYPE_CUSTOMER = 0;

    const SENDER_TYPE_SELLER = 1;

    /**
     * set resource model
     */
    public function _construct()
    {
        $this->_init(\Webkul\Requestforquote\Model\ResourceModel\Conversation::class);
    }

    /**
     * Load No-Route Indexer.
     *
     * @return $this
     */
    public function noRouteReasons()
    {
        return $this->load(self::NOROUTE_ENTITY_ID, $this->getIdFieldName());
    }

    /**
     * Get identities.
     *
     * @return []
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG.'_'.$this->getId()];
    }

    /**
     * Set EntityId
     *
     * @param int $entityId
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * Get EntityId
     *
     * @return int
     */
    public function getEntityId()
    {
        return parent::getData(self::ENTITY_ID);
    }

    /**
     * Set SellerQuoteId
     *
     * @param int $sellerQuoteId
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setSellerQuoteId($sellerQuoteId)
    {
        return $this->setData(self::SELLER_QUOTE_ID, $sellerQuoteId);
    }

    /**
     * Get SellerQuoteId
     *
     * @return int
     */
    public function getSellerQuoteId()
    {
        return parent::getData(self::SELLER_QUOTE_ID);
    }

    /**
     * Set Response
     *
     * @param string $response
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setResponse($response)
    {
        return $this->setData(self::RESPONSE, $response);
    }

    /**
     * Get Response
     *
     * @return string
     */
    public function getResponse()
    {
        return parent::getData(self::RESPONSE);
    }

    /**
     * Set SampleImages
     *
     * @param string $sampleImages
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setSampleImages($sampleImages)
    {
        return $this->setData(self::SAMPLE_IMAGES, $sampleImages);
    }

    /**
     * Get SampleImages
     *
     * @return string
     */
    public function getSampleImages()
    {
        return parent::getData(self::SAMPLE_IMAGES);
    }

    /**
     * Set BulkQuoteQty
     *
     * @param int $bulkQuoteQty
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setBulkQuoteQty($bulkQuoteQty)
    {
        return $this->setData(self::BULK_QUOTE_QTY, $bulkQuoteQty);
    }

    /**
     * Get BulkQuoteQty
     *
     * @return int
     */
    public function getBulkQuoteQty()
    {
        return parent::getData(self::BULK_QUOTE_QTY);
    }

    /**
     * Set QuotePrice
     *
     * @param float $quotePrice
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setQuotePrice($quotePrice)
    {
        return $this->setData(self::QUOTE_PRICE, $quotePrice);
    }

    /**
     * Get QuotePrice
     *
     * @return float
     */
    public function getQuotePrice()
    {
        return parent::getData(self::QUOTE_PRICE);
    }

    /**
     * Set SenderType
     *
     * @param int $senderType
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setSenderType($senderType)
    {
        return $this->setData(self::SENDER_TYPE, $senderType);
    }

    /**
     * Get SenderType
     *
     * @return int
     */
    public function getSenderType()
    {
        return parent::getData(self::SENDER_TYPE);
    }

    /**
     * Set CreatedAt
     *
     * @param string $createdAt
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * Get CreatedAt
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return parent::getData(self::CREATED_AT);
    }

    /**
     * Set UpdatedAt
     *
     * @param string $updatedAt
     * @return Webkul\Requestforquote\Api\Data\ConversationInterface
     */
    public function setUpdatedAt($updatedAt)
    {
        return $this->setData(self::UPDATED_AT, $updatedAt);
    }

    /**
     * Get UpdatedAt
     *
     * @return string
     */
    public function getUpdatedAt()
    {
        return parent::getData(self::UPDATED_AT);
    }
}
