<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Requestforquote
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */


namespace Webkul\Requestforquote\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\DataObject\IdentityInterface;
use Webkul\Requestforquote\Api\Data\InfoInterface;

class Info extends AbstractModel implements IdentityInterface, InfoInterface
{

    const NOROUTE_ENTITY_ID = 'no-route';

    const CACHE_TAG = 'webkul_requestforquote_quoteinfo';

    protected $_cacheTag = 'webkul_requestforquote_quoteinfo';

    protected $_eventPrefix = 'webkul_requestforquote_quoteinfo';

    /**
     * set resource model
     */
    public function _construct()
    {
        $this->_init(\Webkul\Requestforquote\Model\ResourceModel\Info::class);
    }

    /**
     * Load No-Route Indexer.
     *
     * @return $this
     */
    public function noRouteReasons()
    {
        return $this->load(self::NOROUTE_ENTITY_ID, $this->getIdFieldName());
    }

    /**
     * Get identities.
     *
     * @return []
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG.'_'.$this->getId()];
    }

    /**
     * Set EntityId
     *
     * @param int $entityId
     * @return Webkul\Requestforquote\Api\Data\InfoInterface
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * Get EntityId
     *
     * @return int
     */
    public function getEntityId()
    {
        return parent::getData(self::ENTITY_ID);
    }

    /**
     * Set SellerId
     *
     * @param int $sellerId
     * @return Webkul\Requestforquote\Api\Data\InfoInterface
     */
    public function setSellerId($sellerId)
    {
        return $this->setData(self::SELLER_ID, $sellerId);
    }

    /**
     * Get SellerId
     *
     * @return int
     */
    public function getSellerId()
    {
        return parent::getData(self::SELLER_ID);
    }

    /**
     * Set QuoteId
     *
     * @param int $quoteId
     * @return Webkul\Requestforquote\Api\Data\InfoInterface
     */
    public function setQuoteId($quoteId)
    {
        return $this->setData(self::QUOTE_ID, $quoteId);
    }

    /**
     * Get QuoteId
     *
     * @return int
     */
    public function getQuoteId()
    {
        return parent::getData(self::QUOTE_ID);
    }

    /**
     * Set Status
     *
     * @param int $status
     * @return Webkul\Requestforquote\Api\Data\InfoInterface
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * Get Status
     *
     * @return int
     */
    public function getStatus()
    {
        return parent::getData(self::STATUS);
    }

    /**
     * Set CustomerStatus
     *
     * @param int $customerStatus
     * @return Webkul\Requestforquote\Api\Data\InfoInterface
     */
    public function setCustomerStatus($customerStatus)
    {
        return $this->setData(self::CUSTOMER_STATUS, $customerStatus);
    }

    /**
     * Get CustomerStatus
     *
     * @return int
     */
    public function getCustomerStatus()
    {
        return parent::getData(self::CUSTOMER_STATUS);
    }

    /**
     * Set CreatedAt
     *
     * @param string $createdAt
     * @return Webkul\Requestforquote\Api\Data\InfoInterface
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * Get CreatedAt
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return parent::getData(self::CREATED_AT);
    }

    /**
     * Set UpdatedAt
     *
     * @param string $updatedAt
     * @return Webkul\Requestforquote\Api\Data\InfoInterface
     */
    public function setUpdatedAt($updatedAt)
    {
        return $this->setData(self::UPDATED_AT, $updatedAt);
    }

    /**
     * Get UpdatedAt
     *
     * @return string
     */
    public function getUpdatedAt()
    {
        return parent::getData(self::UPDATED_AT);
    }

    /**
     * Set ProductCreated
     *
     * @param int $productCreated
     * @return Webkul\Requestforquote\Api\Data\InfoInterface
     */
    public function setProductCreated($productCreated)
    {
        return $this->setData(self::PRODUCT_CREATED, $productCreated);
    }

    /**
     * Get ProductCreated
     *
     * @return int
     */
    public function getProductCreated()
    {
        return parent::getData(self::PRODUCT_CREATED);
    }

    /**
     * Set OrderCreated
     *
     * @param int $orderCreated
     * @return Webkul\Requestforquote\Api\Data\InfoInterface
     */
    public function setOrderCreated($orderCreated)
    {
        return $this->setData(self::ORDER_CREATED, $orderCreated);
    }

    /**
     * Get OrderCreated
     *
     * @return int
     */
    public function getOrderCreated()
    {
        return parent::getData(self::ORDER_CREATED);
    }
}
