<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Requestforquote
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */


namespace Webkul\Requestforquote\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\DataObject\IdentityInterface;
use Webkul\Requestforquote\Api\Data\ManageattributeInterface;

class Manageattribute extends AbstractModel implements IdentityInterface, ManageattributeInterface
{

    const NOROUTE_ENTITY_ID = 'no-route';

    const CACHE_TAG = 'webkul_requestforquote_manageattribute';

    protected $_cacheTag = 'webkul_requestforquote_manageattribute';

    protected $_eventPrefix = 'webkul_requestforquote_manageattribute';

    /**
     * set resource model
     */
    public function _construct()
    {
        $this->_init(\Webkul\Requestforquote\Model\ResourceModel\Manageattribute::class);
    }

    /**
     * Load No-Route Indexer.
     *
     * @return $this
     */
    public function noRouteReasons()
    {
        return $this->load(self::NOROUTE_ENTITY_ID, $this->getIdFieldName());
    }

    /**
     * Get identities.
     *
     * @return []
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG.'_'.$this->getId()];
    }

    /**
     * Set EntityId
     *
     * @param int $entityId
     * @return Webkul\Requestforquote\Api\Data\ManageattributeInterface
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * Get EntityId
     *
     * @return int
     */
    public function getEntityId()
    {
        return parent::getData(self::ENTITY_ID);
    }

    /**
     * Set AttributeId
     *
     * @param int $attributeId
     * @return Webkul\Requestforquote\Api\Data\ManageattributeInterface
     */
    public function setAttributeId($attributeId)
    {
        return $this->setData(self::ATTRIBUTE_ID, $attributeId);
    }

    /**
     * Get AttributeId
     *
     * @return int
     */
    public function getAttributeId()
    {
        return parent::getData(self::ATTRIBUTE_ID);
    }

    /**
     * Set Label
     *
     * @param string $label
     * @return Webkul\Requestforquote\Api\Data\ManageattributeInterface
     */
    public function setLabel($label)
    {
        return $this->setData(self::LABEL, $label);
    }

    /**
     * Get Label
     *
     * @return string
     */
    public function getLabel()
    {
        return parent::getData(self::LABEL);
    }

    /**
     * Set InputType
     *
     * @param string $inputType
     * @return Webkul\Requestforquote\Api\Data\ManageattributeInterface
     */
    public function setInputType($inputType)
    {
        return $this->setData(self::INPUT_TYPE, $inputType);
    }

    /**
     * Get InputType
     *
     * @return string
     */
    public function getInputType()
    {
        return parent::getData(self::INPUT_TYPE);
    }

    /**
     * Set AttributeCode
     *
     * @param string $attributeCode
     * @return Webkul\Requestforquote\Api\Data\ManageattributeInterface
     */
    public function setAttributeCode($attributeCode)
    {
        return $this->setData(self::ATTRIBUTE_CODE, $attributeCode);
    }

    /**
     * Get AttributeCode
     *
     * @return string
     */
    public function getAttributeCode()
    {
        return parent::getData(self::ATTRIBUTE_CODE);
    }

    /**
     * Set Status
     *
     * @param int $status
     * @return Webkul\Requestforquote\Api\Data\ManageattributeInterface
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * Get Status
     *
     * @return int
     */
    public function getStatus()
    {
        return parent::getData(self::STATUS);
    }

    /**
     * Set IsRequired
     *
     * @param int $isRequired
     * @return Webkul\Requestforquote\Api\Data\ManageattributeInterface
     */
    public function setIsRequired($isRequired)
    {
        return $this->setData(self::IS_REQUIRED, $isRequired);
    }

    /**
     * Get IsRequired
     *
     * @return int
     */
    public function getIsRequired()
    {
        return parent::getData(self::IS_REQUIRED);
    }
}
