<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Requestforquote
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */


namespace Webkul\Requestforquote\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\DataObject\IdentityInterface;
use Webkul\Requestforquote\Api\Data\MapGroupAttributeIdInterface;

class MapGroupAttributeId extends AbstractModel implements IdentityInterface, MapGroupAttributeIdInterface
{

    const NOROUTE_ENTITY_ID = 'no-route';

    const CACHE_TAG = 'webkul_requestforquote_mapgroupattributeid';

    protected $_cacheTag = 'webkul_requestforquote_mapgroupattributeid';

    protected $_eventPrefix = 'webkul_requestforquote_mapgroupattributeid';

    /**
     * set resource model
     */
    public function _construct()
    {
        $this->_init(\Webkul\Requestforquote\Model\ResourceModel\MapGroupAttributeId::class);
    }

    /**
     * Load No-Route Indexer.
     *
     * @return $this
     */
    public function noRouteReasons()
    {
        return $this->load(self::NOROUTE_ENTITY_ID, $this->getIdFieldName());
    }

    /**
     * Get identities.
     *
     * @return []
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG.'_'.$this->getId()];
    }

    /**
     * Set EntityId
     *
     * @param int $entityId
     * @return Webkul\Requestforquote\Api\Data\MapGroupAttributeIdInterface
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * Get EntityId
     *
     * @return int
     */
    public function getEntityId()
    {
        return parent::getData(self::ENTITY_ID);
    }

    /**
     * Set MappingId
     *
     * @param int $mappingId
     * @return Webkul\Requestforquote\Api\Data\MapGroupAttributeIdInterface
     */
    public function setMappingId($mappingId)
    {
        return $this->setData(self::MAPPING_ID, $mappingId);
    }

    /**
     * Get MappingId
     *
     * @return int
     */
    public function getMappingId()
    {
        return parent::getData(self::MAPPING_ID);
    }

    /**
     * Set GroupId
     *
     * @param int $groupId
     * @return Webkul\Requestforquote\Api\Data\MapGroupAttributeIdInterface
     */
    public function setGroupId($groupId)
    {
        return $this->setData(self::GROUP_ID, $groupId);
    }

    /**
     * Get GroupId
     *
     * @return int
     */
    public function getGroupId()
    {
        return parent::getData(self::GROUP_ID);
    }

    /**
     * Set AttributeId
     *
     * @param int $attributeId
     * @return Webkul\Requestforquote\Api\Data\MapGroupAttributeIdInterface
     */
    public function setAttributeId($attributeId)
    {
        return $this->setData(self::ATTRIBUTE_ID, $attributeId);
    }

    /**
     * Get AttributeId
     *
     * @return int
     */
    public function getAttributeId()
    {
        return parent::getData(self::ATTRIBUTE_ID);
    }
}
