<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Requestforquote
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */


namespace Webkul\Requestforquote\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\DataObject\IdentityInterface;
use Webkul\Requestforquote\Api\Data\QuoteInterface;

class Quote extends AbstractModel implements IdentityInterface, QuoteInterface
{

    const NOROUTE_ENTITY_ID = 'no-route';

    const CACHE_TAG = 'webkul_requestforquote_quote';

    protected $_cacheTag = 'webkul_requestforquote_quote';

    protected $_eventPrefix = 'webkul_requestforquote_quote';

    /**
     * set resource model
     */
    public function _construct()
    {
        $this->_init(\Webkul\Requestforquote\Model\ResourceModel\Quote::class);
    }

    /**
     * Load No-Route Indexer.
     *
     * @return $this
     */
    public function noRouteReasons()
    {
        return $this->load(self::NOROUTE_ENTITY_ID, $this->getIdFieldName());
    }

    /**
     * Get identities.
     *
     * @return []
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG.'_'.$this->getId()];
    }

    /**
     * Set EntityId
     *
     * @param int $entityId
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * Get EntityId
     *
     * @return int
     */
    public function getEntityId()
    {
        return parent::getData(self::ENTITY_ID);
    }

    /**
     * Set CustomerId
     *
     * @param int $customerId
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setCustomerId($customerId)
    {
        return $this->setData(self::CUSTOMER_ID, $customerId);
    }

    /**
     * Get CustomerId
     *
     * @return int
     */
    public function getCustomerId()
    {
        return parent::getData(self::CUSTOMER_ID);
    }

    /**
     * Set ProductId
     *
     * @param int $productId
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setProductId($productId)
    {
        return $this->setData(self::PRODUCT_ID, $productId);
    }

    /**
     * Get ProductId
     *
     * @return int
     */
    public function getProductId()
    {
        return parent::getData(self::PRODUCT_ID);
    }

    /**
     * Set ProductWeight
     *
     * @param int $productWeight
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setProductWeight($productWeight)
    {
        return $this->setData(self::PRODUCT_WEIGHT, $productWeight);
    }

    /**
     * Get ProductWeight
     *
     * @return int
     */
    public function getProductWeight()
    {
        return parent::getData(self::PRODUCT_WEIGHT);
    }

    /**
     * Set TaxClassId
     *
     * @param int $taxClassId
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setTaxClassId($taxClassId)
    {
        return $this->setData(self::TAX_CLASS_ID, $taxClassId);
    }

    /**
     * Get TaxClassId
     *
     * @return int
     */
    public function getTaxClassId()
    {
        return parent::getData(self::TAX_CLASS_ID);
    }

    /**
     * Set Subject
     *
     * @param string $subject
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setSubject($subject)
    {
        return $this->setData(self::SUBJECT, $subject);
    }

    /**
     * Get Subject
     *
     * @return string
     */
    public function getSubject()
    {
        return parent::getData(self::SUBJECT);
    }

    /**
     * Set Description
     *
     * @param string $description
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setDescription($description)
    {
        return $this->setData(self::DESCRIPTION, $description);
    }

    /**
     * Get Description
     *
     * @return string
     */
    public function getDescription()
    {
        return parent::getData(self::DESCRIPTION);
    }

    /**
     * Set AttributeDescription
     *
     * @param string $attributeDescription
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setAttributeDescription($attributeDescription)
    {
        return $this->setData(self::ATTRIBUTE_DESCRIPTION, $attributeDescription);
    }

    /**
     * Get AttributeDescription
     *
     * @return string
     */
    public function getAttributeDescription()
    {
        return parent::getData(self::ATTRIBUTE_DESCRIPTION);
    }

    /**
     * Set SampleImages
     *
     * @param string $sampleImages
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setSampleImages($sampleImages)
    {
        return $this->setData(self::SAMPLE_IMAGES, $sampleImages);
    }

    /**
     * Get SampleImages
     *
     * @return string
     */
    public function getSampleImages()
    {
        return parent::getData(self::SAMPLE_IMAGES);
    }

    /**
     * Set BulkOrderQty
     *
     * @param int $bulkOrderQty
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setBulkOrderQty($bulkOrderQty)
    {
        return $this->setData(self::BULK_ORDER_QTY, $bulkOrderQty);
    }

    /**
     * Get BulkOrderQty
     *
     * @return int
     */
    public function getBulkOrderQty()
    {
        return parent::getData(self::BULK_ORDER_QTY);
    }

    /**
     * Set UnitPrice
     *
     * @param float $unitPrice
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setUnitPrice($unitPrice)
    {
        return $this->setData(self::UNIT_PRICE, $unitPrice);
    }

    /**
     * Get UnitPrice
     *
     * @return float
     */
    public function getUnitPrice()
    {
        return parent::getData(self::UNIT_PRICE);
    }

    /**
     * Set DestinationCountry
     *
     * @param string $destinationCountry
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setDestinationCountry($destinationCountry)
    {
        return $this->setData(self::DESTINATION_COUNTRY, $destinationCountry);
    }

    /**
     * Get DestinationCountry
     *
     * @return string
     */
    public function getDestinationCountry()
    {
        return parent::getData(self::DESTINATION_COUNTRY);
    }

    /**
     * Set Status
     *
     * @param int $status
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * Get Status
     *
     * @return int
     */
    public function getStatus()
    {
        return parent::getData(self::STATUS);
    }

    /**
     * Set ApprovedSellerQuoteId
     *
     * @param int $approvedSellerQuoteId
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setApprovedSellerQuoteId($approvedSellerQuoteId)
    {
        return $this->setData(self::APPROVED_SELLER_QUOTE_ID, $approvedSellerQuoteId);
    }

    /**
     * Get ApprovedSellerQuoteId
     *
     * @return int
     */
    public function getApprovedSellerQuoteId()
    {
        return parent::getData(self::APPROVED_SELLER_QUOTE_ID);
    }

    /**
     * Set CreatedAt
     *
     * @param string $createdAt
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * Get CreatedAt
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return parent::getData(self::CREATED_AT);
    }

    /**
     * Set UpdatedAt
     *
     * @param string $updatedAt
     * @return Webkul\Requestforquote\Api\Data\QuoteInterface
     */
    public function setUpdatedAt($updatedAt)
    {
        return $this->setData(self::UPDATED_AT, $updatedAt);
    }

    /**
     * Get UpdatedAt
     *
     * @return string
     */
    public function getUpdatedAt()
    {
        return parent::getData(self::UPDATED_AT);
    }
}
