<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Model\Quote\AttributeSet;

class Options implements \Magento\Framework\Data\OptionSourceInterface
{
    const STATUS_ALL = "";

    const STATUS_ENABLED = 1;

    const STATUS_DISABLED = 0;

    const STATUS_COMPLETE = 2;

    /**
     * @var null|array
     */
    protected $options;

    /**
     * @param \Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory $collectionFactory
     * @param \Magento\Catalog\Model\ResourceModel\Product                            $product
     */
    public function __construct(
        \Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory $collectionFactory,
        \Magento\Catalog\Model\ResourceModel\Product $product
    ) {
        $this->collectionFactory = $collectionFactory;
        $this->product = $product;
    }

    /**
     * Retrieve option array
     *
     * @return string[]
     */
    public function getOptionArray()
    {
        return [
            self::STATUS_ALL => __('All'),
            self::STATUS_ENABLED => __('Sent to Seller'),
            self::STATUS_DISABLED => __('Pending'),
            self::STATUS_COMPLETE => __('Completed')
        ];
    }

    /**
     * Retrieve option array with empty value
     *
     * @return string[]
     */
    public function getAllOptions()
    {
        $result = [];
        foreach ($this->getOptionArray() as $index => $value) {
            $result[] = ['value' => $index, 'label' => $value];
        }
        return $result;
    }
    public function toOptionArray()
    {
        $this->options = $this->getAllOptions();
        return $this->options;
    }
}
