<?php
/**
 *
 *
 * @category Webkul
 * @package  Webkul_Requestforquote
 * @author   Webkul Software Private Limited
 */
namespace Webkul\Requestforquote\Model\ResourceModel\Systemattribute;

// use \Webkul\Requestforquote\Model\ResourceModel\AbstractCollection;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

class Collection extends AbstractCollection
{
    /**
     * @var string
     */
    protected $_idFieldName = 'attribute_id';

    /**
     * Define resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(
            \Webkul\Requestforquote\Model\Systemattribute::class,
            \Webkul\Requestforquote\Model\ResourceModel\Systemattribute::class
        );
        $this->addFilterToMap(
            'attribute_id',
            'main_table.attribute_id'
        );
    }
    
    /**
     * Add filter by store
     *
     * @param  int|array|\Magento\Store\Model\Store $store
     * @param  bool                                 $withAdmin
     * @return $this
     */
    public function addStoreFilter($store, $withAdmin = true)
    {
        if (!$this->getFlag('store_filter_added')) {
            $this->performAddStoreFilter($store, $withAdmin);
        }
        return $this;
    }
}
