<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\Requestforquote\Model\ResourceModel\Systemattribute\Grid;

use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Magento\Framework\Api\Search\SearchResultInterface as ApiSearchResultInterface;
use Webkul\Requestforquote\Model\ResourceModel\Systemattribute\Collection as SystemattributeCollection;
use Magento\Framework\Search\AggregationInterface as SearchAggregationInterface;
use Magento\Framework\Data\Collection\EntityFactoryInterface;
use Psr\Log\LoggerInterface;
use Magento\Framework\Data\Collection\Db\FetchStrategyInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\Event\ManagerInterface as EventManagerInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb as ResourceModelAbstractDb;

/**
 * Webkul\Requestforquote\Model\ResourceModel\Systemattribute\Grid\Collection Class
 * Collection for displaying grid of Requestforquote systemattribute.
 */
class Collection extends AbstractCollection implements ApiSearchResultInterface
{
    /**
     * @var string
     */
    protected $_idFieldName = 'attribute_id';
    /**
     * @var SearchAggregationInterface
     */
    protected $aggregations;

    /**
     * @param EntityFactoryInterface                               $entityFactoryInterface
     * @param LoggerInterface                                      $loggerInterface
     * @param FetchStrategyInterface                               $fetchStrategyInterface
     * @param EventManagerInterface                                $eventManagerInterface
     * @param StoreManagerInterface                                $storeManagerInterface
     * @param mixed|null                                           $mainTable
     * @param \Magento\Framework\Model\ResourceModel\Db\AbstractDb $eventPrefix
     * @param mixed                                                $eventObject
     * @param mixed                                                $resourceModel
     * @param string                                               $model
     * @param null                                                 $connection
     * @param ResourceModelAbstractDb|null                         $resource
     */
    public function __construct(
        EntityFactoryInterface $entityFactoryInterface,
        LoggerInterface $loggerInterface,
        FetchStrategyInterface $fetchStrategyInterface,
        EventManagerInterface $eventManagerInterface,
        $mainTable,
        $eventPrefix,
        $eventObject,
        $resourceModel,
        \Webkul\Requestforquote\Model\ManageattributeFactory $manageAttrFactory,
        $model = \Magento\Framework\View\Element\UiComponent\DataProvider\Document::class,
        \Magento\Framework\DB\Adapter\AdapterInterface $connection = null,
        ResourceModelAbstractDb $resource = null
    ) {

        parent::__construct(
            $entityFactoryInterface,
            $loggerInterface,
            $fetchStrategyInterface,
            $eventManagerInterface,
            $connection,
            $resource
        );
        $this->_eventPrefix = $eventPrefix;
        $this->manageAttrFactory = $manageAttrFactory;
        $this->_eventObject = $eventObject;
        $this->_init($model, $resourceModel);
        $this->setMainTable($mainTable);
    }
    protected function _construct()
    {
        $this->_init(
            \Webkul\Requestforquote\Model\Systemattribute::class,
            \Webkul\Requestforquote\Model\ResourceModel\Systemattribute::class
        );
    }

    /**
     * @return SearchAggregationInterface
     */
    public function getAggregations()
    {
        return $this->aggregations;
    }

    /**
     * @param SearchAggregationInterface $aggregationsData
     *
     * @return $this
     */
    public function setAggregations($aggregationsData)
    {
        $this->aggregations = $aggregationsData;
    }

    /**
     * Get search criteria.
     *
     * @return \Magento\Framework\Api\SearchCriteriaInterface|null
     */
    public function getSearchCriteria()
    {
        return null;
    }

    /**
     * Set search criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return                                        $this
     */
    public function setSearchCriteria(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria = null
    ) {

        return $this;
    }

    /**
     * Get total count.
     *
     * @return int
     */
    public function getTotalCount()
    {
        return $this->getSize();
    }

    /**
     * Set total count.
     *
     * @param int $totalCount
     *
     * @return                                        $this
     */
    public function setTotalCount($totalCount)
    {
        return $this;
    }

    /**
     * Set items list.
     *
     * @param \Magento\Framework\Api\ExtensibleDataInterface[] $items
     *
     * @return                                        $this
     */
    public function setItems(array $items = null)
    {
        return $this;
    }

    /**
     * Join store relation table if there is store filter.
     */
    protected function _renderFiltersBefore()
    {
        $manageAttribute = $this->manageAttrFactory;
        $manageAttrIdsEnable = $manageAttribute->create()
        ->getCollection()->addFieldToSelect('attribute_id')->addFieldToFilter('status', ['eq'=>1]);
        $manageAttrIdsDisable = $manageAttribute->create()
        ->getCollection()->addFieldToSelect('attribute_id')->addFieldToFilter('status', ['eq'=>0]);
        $enable ='';
        $disable ='';
        foreach ($manageAttrIdsEnable as $manageAttrId) {
            $enable.= $manageAttrId['attribute_id'].',';
        }
        foreach ($manageAttrIdsDisable as $manageAttrId) {
            $disable.= $manageAttrId['attribute_id'].',';
        }
        if ($disable =="") {
            $disable = 'null';
        }
        if ($enable =="") {
            $enable = 'null';
        }
        $where = $this->getSelect()->getPart('where');
        foreach ($where as $key => $condition) {
            if ($condition == "(`status` = '0')" || $condition == "AND (`status` = '0')") {
                if ($condition == "(`status` = '0')") {
                    $where[$key] = "(`attribute_id` IN (".rtrim($disable, ',')."))";
                }
                if ($condition == "AND (`status` = '0')") {
                    $where[$key] = "AND (`attribute_id` IN (".rtrim($disable, ',')."))";
                }
            }
            if ($condition == "(`status` = '1')" || $condition == "AND (`status` = '1')") {
                if ($condition == "(`status` = '1')") {
                    $where[$key] = "(`attribute_id` IN (".rtrim($enable, ',')."))";
                }
                if ($condition == "AND (`status` = '1')") {
                    $where[$key] = "AND (`attribute_id` IN (".rtrim($enable, ',')."))";
                }
            }
        }
        $this->getSelect()->setPart('where', $where);

        $this->getSelect()->where(
            'is_user_defined=1 and entity_type_id=4 and frontend_input="text"'
        );
        $this->addExpressionFieldToSelect(
            'showinquotefrm',
            new \Zend_Db_Expr('IF(attribute_id IN('.rtrim($enable, ',').'), "Yes", "No")'),
            []
        );
        parent::_renderFiltersBefore();
    }
}
