<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\Requestforquote\Observer;
 
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\App\RequestInterface;

class AfterPlaceOrder implements ObserverInterface
{

    /**
     * @var \Magento\Sales\Model\Order
     */
    private $salesOrder;
    
    /**
     * @var \Webkul\Requestforquote\Model\InfoFactory
     */
    private $info;

    /**
     * __construct function
     *
     * @param \Magento\Sales\Model\Order                $salesOrder
     * @param \Webkul\Requestforquote\Model\InfoFactory $info
     */
    public function __construct(
        \Magento\Sales\Model\Order $salesOrder,
        \Webkul\Requestforquote\Model\InfoFactory $info,
        \Webkul\Requestforquote\Model\QuoteFactory $rfqQuote
    ) {
        $this->salesOrder = $salesOrder;
        $this->info = $info;
        $this->rfqQuote = $rfqQuote;
    }

    /**
     * This is the method that fires when the event runs.
     *
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        $oids=$observer->getOrderIds();
        $sl = $this->salesOrder->load($oids);
        foreach ($sl->getAllItems() as $item) {
            if ($item->getProductType() ==  "quote") {
                $productOptions = $item->getProductOptions();
                if (isset($productOptions['info_buyRequest'])
                    && isset($productOptions['info_buyRequest']['quoteInfoId'])
                ) {
                    $quoteInfoId = $productOptions['info_buyRequest']['quoteInfoId'];
                    $infoModel = $this->info->create();
                    $infoModel->load($quoteInfoId);
                    $infoModel->setOrderCreated(1);
                    $infoModel->save();
                    $rfqQuote = $this->rfqQuote->create()->getCollection();
                    $rfqQuoteData = $rfqQuote
                    ->addFieldToFilter('entity_id', $infoModel->getQuoteId())->getFirstItem();
                    $rfqQuoteData->setStatus(2);
                    $rfqQuoteData->save();
                }
            }
        }
    }
}
