<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\Requestforquote\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\App\RequestInterface;

class BeforeDeleteQuoteProduct implements ObserverInterface
{
    /**
     * @var \Magento\Framework\App\State $state
     */
    private $state;

    /**
     * Constructer
     */
    public function __construct(
        \Magento\Framework\App\State $state,
        \Webkul\Requestforquote\Model\QuoteFactory $quote,
        \Webkul\Requestforquote\Model\InfoFactory $info
    ) {
        $this->state = $state;
        $this->quote = $quote;
        $this->info = $info;
    }

    /**
     * This is the method that fires when the event runs.
     *
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        if ($observer->getObject()->getTypeId() == 'quote' && $this->state->getAreaCode() == 'adminhtml') {
                $productId = $observer->getObject()->getEntityId();
                $rfqQuoteModel = $this->quote->create();
                $rfqQuoteModel->load($productId, 'product_id');
            if ($rfqQuoteModel->getEntityId() != null) {
                $rfqQuoteInfoModel = $this->info->create();
                $rfqQuoteInfoModel->load($rfqQuoteModel->getEntityId(), 'quote_id');
                if ($rfqQuoteInfoModel->getData('product_created') == 1
                    && $rfqQuoteInfoModel->getData('order_created') == 0
                ) {
                    $rfqQuoteInfoModel->setData('product_created', 0);
                    $rfqQuoteInfoModel->save();
                }
            }
        }
    }
}
