<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\Requestforquote\Observer;
 
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\App\RequestInterface;

class CatalogProductAttributeUpdateBefore implements ObserverInterface
{

    /**
     * @var \Magento\Framework\Message\ManagerInterface
     */
    private $messageManager;
    
    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    private $product;

    /**
     * __construct function
     *
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     * @param \Magento\Catalog\Model\ProductFactory       $product
     */
    public function __construct(
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Magento\Catalog\Model\ProductFactory $product,
        \Magento\Framework\App\Request\Http $request
    ) {
        $this->messageManager = $messageManager;
        $this->product = $product;
        $this->request = $request;
    }

    /**
     * This is the method that fires when the event runs.
     *
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        try {
            $controllerName = $this->request->getControllerName();
            $routeName = $this->request->getRouteName();
            if ($routeName != "marketplace" && $controllerName != "seller") {
                $data = $observer->getEvent()->getData();
                $productIdsForChangeAttr = &$data['product_ids'];
                $quoteTypeProIdsColl = $this->product->create()->getCollection()
                ->addFieldToSelect('entity_id')
                ->addFieldToFilter('type_id', ['eq'=>'quote']);
                $quoteTypeProIds = $quoteTypeProIdsColl->getColumnValues('entity_id');
                $count1 = count($productIdsForChangeAttr);
                $filterIds = array_diff($productIdsForChangeAttr, $quoteTypeProIds);
                $count2 = count($filterIds);
                $productIdsForChangeAttr = $filterIds;
                if ($count1 != $count2) {
                    $this->messageManager->addError(_('Cannot change attribute(s) of quote type product(s)'));
                }
                $productIds = [];
            }
        } catch (\Exception $e) {
            $this->messageManager->addError(_($e->getMessage()));
        }
    }
}
