<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\App\RequestInterface;
use Webkul\Requestforquote\Helper\Data;

class CustomPrice implements ObserverInterface
{
    public function __construct(
        Data $helper
    ) {
        $this->helper = $helper;
    }
    /**
     * This is the method that fires when the event runs.
     *
     * @param Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $helper = $this->helper;
        $item = $observer->getEvent()->getData('quote_item');
        $product = $observer->getEvent()->getData('product');
        if ($item != null && $item->getProductType() == 'quote') {
            $buyRequest = $item->getBuyRequest();
            $baseCurrencyCode = $helper->getBaseCurrencyCode();
            $currentCurrencyCode = $helper->getCurrentCurrencyCode();
            $priceOne = $helper->getwkconvertCurrency(
                $baseCurrencyCode,
                $currentCurrencyCode,
                $buyRequest['price']
            );
            $item = ( $item->getParentItem() ? $item->getParentItem() : $item );
            $item->getProduct()->setIsSuperMode(true);
        }
    }
}
