<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\Requestforquote\Observer;
 
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\App\RequestInterface;

class MpSellerProductEdit implements ObserverInterface
{

    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    private $product;

    /**
     * __construct function
     *
     * @param \Magento\Catalog\Model\ProductFactory $product
     */
    public function __construct(
        \Magento\Catalog\Model\ProductFactory $product
    ) {
        $this->product = $product;
    }

    /**
     * This is the method that fires when the event runs.
     *
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        $data = $observer->getEvent()->getData();
        if (isset($data[0]['id'])) {
            $productId = $data[0]['id'];
            $model = $this->product->create();
            $model->load($productId);
            $productType = $model->getTypeId();
            if ($productType == 'quote') {
                throw new LocalizedException(
                    __(
                        'You are not authorize to edit/save product(s) of type quote.'
                    )
                );
            }
        }
    }
}
