<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\Requestforquote\Observer;
 
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\App\RequestInterface;

class NewAction implements ObserverInterface
{

    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    private $requestInterface;
    
    /**
     * @var \Magento\Framework\App\ResponseFactory
     */
    private $responseFactory;
    
    /**
     * @var \Magento\Framework\Message\ManagerInterface
     */
    private $messageManager;
    
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $url;
    
    /**
     * __construct function
     *
     * @param \Magento\Framework\UrlInterface             $url
     * @param \Magento\Framework\App\RequestInterface     $requestInterface
     * @param \Magento\Framework\App\ResponseFactory      $responseFactory
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     */
    public function __construct(
        \Magento\Framework\UrlInterface $url,
        \Magento\Framework\App\RequestInterface $requestInterface,
        \Magento\Framework\App\ResponseFactory $responseFactory,
        \Magento\Framework\Message\ManagerInterface $messageManager
    ) {
        $this->url = $url;
        $this->requestInterface = $requestInterface;
        $this->responseFactory = $responseFactory;
        $this->messageManager = $messageManager;
    }

    /**
     * This is the method that fires when the event runs.
     *
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        $productId = $observer->getProduct()->getTypeId();
        $requetData = $this->requestInterface->getParams();
        if ($productId == 'quote') {
            $requetData['type'] = 'simple';
            $this->messageManager->addError(__('cannot add product type quote'));
            $url = 'catalog/product/new/set/'.$requetData['set'].'/type/simple/key/'.$requetData['key'];
            $CustomRedirectionUrl = $this->url->getUrl($url);
            $this->responseFactory->create()->setRedirect($CustomRedirectionUrl)->sendResponse();
        }
    }
}
