<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\Requestforquote\Observer;
 
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Exception\LocalizedException;

class ProductViewOfQuoteType implements ObserverInterface
{
    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    private $requestInterface;
    
    /**
     * @var \Magento\Framework\App\Response\Http
     */
    private $redirect;
    
    /**
     * @var \Magento\Framework\App\ResponseFactory
     */
    private $responseFactory;
    
    /**
     * @var \Magento\Framework\Message\ManagerInterface
     */
    private $messageManager;
    
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $url;
    
    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    private $productFactory;
    
    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    private $storeManager;

    /**
     * __construct function
     *
     * @param \Magento\Framework\UrlInterface             $url
     * @param \Magento\Framework\App\Response\Http        $redirect
     * @param \Magento\Framework\App\RequestInterface     $requestInterface
     * @param \Magento\Framework\App\ResponseFactory      $responseFactory
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     * @param \Magento\Catalog\Model\ProductFactory       $productFactory
     * @param \Magento\Store\Model\StoreManagerInterface  $storeManager
     */
    public function __construct(
        \Magento\Framework\UrlInterface $url,
        \Magento\Framework\App\Response\Http $redirect,
        \Magento\Framework\App\RequestInterface $requestInterface,
        \Magento\Framework\App\ResponseFactory $responseFactory,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    ) {
        $this->url = $url;
        $this->requestInterface = $requestInterface;
        $this->redirect = $redirect;
        $this->responseFactory = $responseFactory;
        $this->messageManager = $messageManager;
        $this->productFactory = $productFactory;
        $this->storeManager = $storeManager;
    }

    /**
     * This is the method that fires when the event runs.
     *
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        try {
            $productId = (int) $this->requestInterface->getParam('id');
            $product = $this->productFactory->create()->load($productId);
            if ($product->getTypeId() == 'quote') {
                throw new LocalizedException(
                    __(
                        'cannot view the product of type quote.'
                    )
                );
            }
        } catch (\Exception $e) {
            $baseUrl = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_WEB);
            $this->messageManager->addError(__($e->getMessage()));
            $customRedirectionUrl = $this->url->getUrl($baseUrl);
            $this->redirect->setRedirect($customRedirectionUrl);
            return false;
        }
    }
}
