<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul Software Private Limited
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\Requestforquote\Observer;
 
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Exception\LocalizedException;

class Productsaveafter implements ObserverInterface
{

    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    private $requestInterface;
    
    /**
     * @var \Magento\Framework\App\Response\Http
     */
    private $redirect;
    
    /**
     * @var \Magento\Framework\App\ResponseFactory
     */
    private $responseFactory;
    
    /**
     * @var \Magento\Framework\Message\ManagerInterface
     */
    private $messageManager;
    
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $url;

    /**
     * __construct function
     *
     * @param \Magento\Framework\UrlInterface             $url
     * @param \Magento\Framework\App\Response\Http        $redirect
     * @param \Magento\Framework\App\RequestInterface     $requestInterface
     * @param \Magento\Framework\App\ResponseFactory      $responseFactory
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     */
    public function __construct(
        \Magento\Framework\UrlInterface $url,
        \Magento\Framework\App\Response\Http $redirect,
        \Magento\Framework\App\RequestInterface $requestInterface,
        \Magento\Framework\App\ResponseFactory $responseFactory,
        \Magento\Framework\Message\ManagerInterface $messageManager
    ) {
        $this->url = $url;
        $this->requestInterface = $requestInterface;
        $this->redirect = $redirect;
        $this->responseFactory = $responseFactory;
        $this->messageManager = $messageManager;
    }

    /**
     * This is the method that fires when the event runs.
     *
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        try {
            $productId = $observer->getProduct()->getTypeId();
            $requetData = $this->requestInterface->getParams();
            if ($productId == 'quote') {
                throw new LocalizedException(
                    __(
                        'Edit operation is forbidden of the product of type quote.'
                    )
                );
            }
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
            $redirectUrl = $this->url->getUrl('catalog/product/index');
            $this->responseFactory->create()->setRedirect($redirectUrl)->sendResponse();
            $observer->getControllerAction()->getResponse()->setRedirect($redirectUrl);
            return $this;
        }
    }
}
