<?php

/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\Requestforquote\Plugin\Checkout\Block\Cart;

class GetCartItemHtml
{
    /**
     * @var \Magento\Checkout\Model\Cart
     */
    protected $item;

    /**
     * @param \Magento\Checkout\Model\Cart $item
     */
    public function __construct(
        \Magento\Checkout\Model\Cart $item
    ) {
        $this->item = $item;
    }

    /**
     * plugin to disable the quantity input element so that it's quantity cannot be chabge and remain always 1
     * of caret item.
     *
     * @param  \Magento\Checkout\Block\Cart
     * @param  Closure                         $result
     * @param  \Magento\Quote\Model\Quote\Item
     * @return html
     */
    public function aroundGetItemHtml(
        \Magento\Checkout\Block\Cart $subject,
        $proceed,
        \Magento\Quote\Model\Quote\Item $item
    ) {
        if ($item->getProductType() == "quote") {
            $result = $proceed($item);
            $match = explode('<input', $result);
            $match2 = explode('/>', $match[1]);
            return str_replace("<input".$match2[0]."/>", '<span>'.$item->getQty().'<span>', $result);
        } else {
            return $proceed($item);
        }
    }
}
