<?php

/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\Requestforquote\Plugin\Checkout\CustomerData;

class Cart
{
    /**
     * @var \Magento\Checkout\Model\Session
     */
    public $checkoutSession;

    /**
     * @var \Magento\Catalog\Model\ResourceModel\Url
     */
    public $catalogUrl;

    /**
     * __construct
     *
     * @param \Webkul\Requestforquote\Helper\Data $helper
     */
    public function __construct(
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Catalog\Model\ResourceModel\Url $catalogUrl
    ) {
        $this->checkoutSession = $checkoutSession;
        $this->catalogUrl = $catalogUrl;
    }

    /**
     * Plugin to add thwe quote type product in mini cart
     *
     * @param  \Magento\Checkout\CustomerData\Cart $subject
     * @param  array                               $result
     * @return array
     */
    public function afterGetSectionData(\Magento\Checkout\CustomerData\Cart $subject, $result)
    {
        return $this->getRecentItems($subject, $result);
    }

    /**
     * Get array of last added items
     *
     * @return \Magento\Quote\Model\Quote\Item[]
     */
    public function getRecentItems($subject, $result)
    {
        $reflCart = new \ReflectionClass(\Magento\Checkout\CustomerData\Cart::class);
        $reflProp = $reflCart->getProperty('itemPoolInterface');
        $reflProp->setAccessible(true);
        foreach (array_reverse($this->getAllQuoteItems()) as $item) {
            /* @var $item \Magento\Quote\Model\Quote\Item */
            if (!$item->getProduct()->isVisibleInSiteVisibility()) {
                $product =  $item->getOptionByCode('product_type') !== null
                    ? $item->getOptionByCode('product_type')->getProduct()
                    : $item->getProduct();
                if ($product->getTypeId()== 'quote') {
                    $products[$product->getRowId()] = [
                        'store_id'=>$product->getStoreId(),
                        'visibility'=> $product->getVisibility(),
                        'url_rewrite'=>'#'
                    ];
                    $urlDataObject = new \Magento\Framework\DataObject($products[$product->getRowId()]);
                    $item->getProduct()->setUrlDataObject($urlDataObject);
                    $result['items'][]= $reflProp->getValue($subject)->getItemData($item);
                }
            }
        }
        return $result;
    }

    /**
     * getQuote function get the instance of quote
     *
     * @return \Magento\Quote\Model\Quote
     */
    public function getQuote()
    {
        $this->quote = $this->checkoutSession->getQuote();
        return $this->quote;
    }

    /**
     * Return customer quote items
     *
     * @return \Magento\Quote\Model\Quote\Item[]
     */
    public function getAllQuoteItems()
    {
        return $this->getQuote()->getAllVisibleItems();
    }
}
