<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Plugin\Marketplace\Helper;

class Data
{
    /**
     * Prepare Permissions Mapping with controllers.
     *
     * @param \Webkul\Marketplace\Helper\Data $helperData
     * @param array                           $result
     *
     * @return bool
     */
    public function afterGetControllerMappedPermissions(
        \Webkul\Marketplace\Helper\Data $helperData,
        $result
    ) {
        return $result;
    }

    /**
     * Plugin to add the quote type in allowed product types
     *
     * @param  \Webkul\Marketplace\Helper\Data $subject
     * @param  String                          $result
     * @return String
     */
    public function afterGetAllowedProductType(\Webkul\Marketplace\Helper\Data $subject, $result)
    {
        $allProTypeArray = explode(',', $result);
        $allProTypeArray[] = 'quote';
        return implode(',', $allProTypeArray);
    }
}
