<?php

/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\Requestforquote\Plugin\Product\Edit\Action;

class GetProductIds
{
    /**
     * @var \Magento\Framework\Message\ManagerInterface
     */
    protected $messageManager;
    
    /**
     * @var \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory
     */
    protected $productCollection;
    
    /**
     * __construct function
     *
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollection
     * @param \Magento\Framework\Message\ManagerInterface                    $messageManager
     */
    public function __construct(
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollection,
        \Magento\Framework\Message\ManagerInterface $messageManager
    ) {
        $this->productCollection = $productCollection;
        $this->messageManager = $messageManager;
    }

    /**
     * Plugin to filter the quote type product ids
     *
     * @param  \Magento\Catalog\Helper\Product\Edit\Action\Attribute $subject
     * @param  array                                                 $result
     * @return array
     */
    public function afterGetProductIds(\Magento\Catalog\Helper\Product\Edit\Action\Attribute $subject, $result)
    {
        $filteredCollQuoteType = $this->productCollection->create()->addFieldToSelect('entity_id')
            ->addFieldToFilter('type_id', ['eq'=>'quote'])
            ->getColumnValues('entity_id');
        $count1 = count($result);
        $filterIds = array_diff($result, $filteredCollQuoteType);
        $count2 = count($filterIds);
        if ($count1 != $count2) {
            $allMessages= $this->messageManager->getMessages()->getItems();
            $flag = 1;
            foreach ($allMessages as $allMessage) {
                if ($allMessage->getText() == __('Cannot change attribute(s) of quote type product(s)')) {
                    $flag = 0;
                    break;
                }
            }
            if ($flag) {
                $this->messageManager->addError(__('Cannot change attribute(s) of quote type product(s)'));
            }
        }
        $result = $filterIds;
        return $result;
    }
}
