<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Webkul\Requestforquote\Ui\Component;

use Magento\Framework\Data\Collection;
use Magento\Framework\Api\Search\SearchCriteriaInterface;

/**
 * Class FilterPool
 *
 * @api
 * @since 100.0.2
 */
class FilterPoolupdated extends \Magento\Framework\View\Element\UiComponent\DataProvider\FilterPool
{
    /**
     * @var array
     */
    protected $appliers;

    /**
     * @param array $appliers
     */
    public function __construct(
        \Magento\Catalog\Model\CategoryFactory $_categoryFactory,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory $attributeSetCollection,
        array $appliers = []
    ) {
        $this->_categoryFactory = $_categoryFactory;
        $this->_attributeSetCollection = $attributeSetCollection;
        $this->appliers = $appliers;
    }

    /**
     * @param Collection $collection
     * @param SearchCriteriaInterface $criteria
     * @return void
     */
    public function applyFilters(Collection $collection, SearchCriteriaInterface $criteria)
    {
        foreach ($criteria->getFilterGroups() as $filterGroup) {
            foreach ($filterGroup->getFilters() as $filter) {
                /** @var $filterApplier FilterApplierInterface*/
                if (isset($this->appliers[$filter->getConditionType()])) {
                    $filterApplier = $this->appliers[$filter->getConditionType()];
                } else {
                    $filterApplier = $this->appliers['regular'];
                }
                if ($filter->getField() == "category_id") {
                    $categoryTitle = strtolower(trim(($filter->getValue()), "%"));
                    $categoryCollection = $this->_categoryFactory->create()->getCollection()
                    ->addFieldToFilter('name', ['in' => $categoryTitle]);
                    if (!empty($categoryCollection->getData())) {
                        $categoryId = $categoryCollection->getData()[0]['entity_id'];
                        $filter->setValue($categoryId);
                    }
                } elseif ($filter->getField() == "attribute_set_id") {
                    $attrSetName = trim(($filter->getValue()), "%");
                    $attributeSet = $this->_attributeSetCollection->create()->addFieldToSelect(
                        'attribute_set_id'
                    )->addFieldToFilter(
                        'attribute_set_name',
                        $attrSetName
                    );
                    if (count($attributeSet->getData())) {
                        $attributeSetId = $attributeSet->getData()[0]['attribute_set_id'];
                        $filter->setValue($attributeSetId);
                    }
                }
                $filterApplier->apply($collection, $filter);
            }
        }
    }
}
