<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Ui\Component\Listing\Columns;

use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Store\Model\StoreManagerInterface;
use Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterfaceFactory;

/**
 * BannerImages Ui Component Listing Columns Image
 */
class CategoryName extends \Magento\Ui\Component\Listing\Columns\Column
{
    /**
     * @var \Webkul\Requestforquote\Api\Data\CategoryAttributeMappingInterfaceFactory
     */
    protected $categoryAttributeMapping;

    /**
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param \Magento\Framework\UrlInterface $urlBuilder
     * @param StoreManagerInterface $storemanager
     * @param array $components
     * @param array $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        \Magento\Framework\UrlInterface $urlBuilder,
        StoreManagerInterface $storemanager,
        CategoryAttributeMappingInterfaceFactory $categoryAttributeMapping,
        \Magento\Catalog\Model\CategoryFactory $category,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->urlBuilder = $urlBuilder;
        $this->storeManager = $storemanager;
        $this->categoryAttributeMapping = $categoryAttributeMapping;
        $this->category = $category;
        $this->editUrl ="";
    }

    /**
     * prepareDataSource
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $categoryAttributeMapping = $this->categoryAttributeMapping->create()->load($item['entity_id']);
                $categoryName = $this->category->create()->load($categoryAttributeMapping->getCategoryId())->getName();
                $item['category_id'] = $categoryName;
            }
        }
        return $dataSource;
    }
}
