<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Requestforquote\Ui\DataProvider;

use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory as ProductCollection;
use Webkul\Requestforquote\Model\ResourceModel\Info\CollectionFactory;
use Webkul\Marketplace\Helper\Data as HelperData;

/**
 * Class ProductListDataProvider
 */
class AllRequestedQuotes extends \Magento\Ui\DataProvider\AbstractDataProvider
{
    /**
     * Product collection
     *
     * @var \Webkul\Marketplace\Model\ResourceModel\Product\Collection
     */
    protected $collection;

    /**
     * @var \Magento\Framework\Registry
     */
    protected $_registry;

    /**
     * Construct
     *
     * @param string                      $name
     * @param string                      $primaryFieldName
     * @param string                      $requestFieldName
     * @param ProductCollection           $productCollection
     * @param CollectionFactory           $collectionFactory
     * @param HelperData                  $helperData
     * @param \Magento\Framework\Registry $registry
     * @param array                       $meta
     * @param array                       $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        ProductCollection $productCollection,
        CollectionFactory $collectionFactory,
        HelperData $helperData,
        \Magento\Framework\App\RequestInterface $request,
        \Magento\Framework\Registry $registry,
        \Webkul\Marketplace\Helper\Data $mpHelper,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute $eavAttribute,
        array $addFieldStrategies = [],
        array $addFilterStrategies = [],
        array $meta = [],
        array $data = []
    ) {
        parent::__construct(
            $name,
            $primaryFieldName,
            $requestFieldName,
            $meta,
            $data
        );
        $customerId = $mpHelper->getCustomerId();
        $sellerId = $mpHelper->getCustomerId();
        $quotes = $collectionFactory->create();
        $quotes->addFieldToFilter('seller_id', $sellerId);
        $rfqQuoteTable = $quotes->getResource()->getTable("requestforquote_quote");
        $quotes->getSelect()
            ->join(
                $rfqQuoteTable.' as rfq',
                "main_table.quote_id = rfq.entity_id",
                [
                "subject" => "subject",
                "description" => "description",
                "customer_id" => "customer_id"
                ]
            );
        $quotes ->getSelect()
            ->order('main_table.created_at DESC');
        $fnameid = $eavAttribute->getIdByCode('customer', 'firstname');
        $lnameid = $eavAttribute->getIdByCode('customer', 'lastname');
        $quotes->getSelect()
            ->join(
                [
                "ce1" => $quotes->getResource()->getTable("customer_entity")
                ],
                "rfq.customer_id = ce1.entity_id",
                [
                "firstname" => "firstname",
                "lastname" => "lastname"
                ]
            )->where(
                "ce1.entity_id = rfq.customer_id"
            )
            ->columns(
                new \Zend_Db_Expr(
                    "CONCAT(ce1.firstname, ' ',ce1.lastname) AS customer_name"
                )
            );
        $quotes->addFilterToMap(
            "customer_name",
            new \Zend_Db_Expr(
                "CONCAT(ce1.firstname, ' ',ce1.lastname)"
            )
        );
        $quotes->addFilterToMap("status", "main_table.status");
        $quotes->addFilterToMap("created_at", "main_table.created_at");
        $this->collection = $quotes;
        $this->addFieldStrategies = $addFieldStrategies;
        $this->addFilterStrategies = $addFilterStrategies;
    }
}
