/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
/*jshint jquery:true*/
define([
    'jquery',
    'mage/template',
    'Magento_Ui/js/modal/alert',
    'mage/validation',
    'mage/calendar',
], function ($,template,alert) {
    'use strict';
    $.widget('mage.sellerViewJs', {

        options: {},
        _create: function () {
            var self = this;
            $.validator.addMethod(
            'integer', function (value, element) { 
            return this.optional(element) || /^-?\d+$/.test(value);
            }, $.mage.__('Please enter a positive non-decimal number in this field.'));
    
            var i = self.options.i;
            $(document).ready(function(){
                $('.wk_req_admin_defined_attribute_span_text').css('display','block');
                $('.wk_req_admin_defined_attribute_input').css('display','none');
            });
            $(document).on('change', '#sample_images', function () {
                var thisthis = $(this);
                var countlength = 0;
                var length = thisthis.prop("files").length;
                $.each(thisthis.prop("files"), function (index, value) {
                    thisthis.parent().find('.wk_mp_rfq_image_label')
                    .html('<div style="position:relative;top:23px;" class="cp-spinner cp-round"></div>');
                    var file_data = thisthis.prop("files")[index];
                    var form_data = new FormData();
                    form_data.append("sample_images", file_data);
                    $.ajax({
                        url: self.options.sampleUpload,
                        dataType: 'json',
                        cache: false,
                        contentType: false,
                        processData: false,
                        data: form_data,
                        type: 'POST',
                        success: function (content) {
                            if(content.type){
                                var templatee = "";
                                var ImageTemplate = template('#requestForQuoteImageTemplate');
                                    templatee += ImageTemplate({
                                    data: {
                                        index:i,
                                        imageUrl:content.fileurl,
                                        imageName:content.filename
    
                                    }
                                });
                                $(templatee).insertBefore(".wk_mp_rfq_image_label");
                                thisthis.val('');
                                i = i+1;
                                countlength = countlength+1;
                                if (countlength == length) {
                                    thisthis.parent().find('.wk_mp_rfq_image_label')
                                    .html('<span class="wk_mp_rfq_image_span_icon">+</span>'+
                                    '<span class="wk_mp_rfq_image_span_text">'+$.mage.__("Click here to add sample files") +'...</span>');
                                }
                            }else{
                                thisthis.parent().find('.wk_mp_rfq_image_label')
                                .html('<span class="wk_mp_rfq_image_span_icon">+</span>'+
                                '<span class="wk_mp_rfq_image_span_text">'+$.mage.__("Click here to add sample files") +'...</span>');
                                thisthis.val('');
                                alert({
                                    content: content.errormsg
                                });
                            }
                        },
                        error: function (content) {
                            thisthis.parent().find('.wk_mp_rfq_image_label')
                            .html('<span class="wk_mp_rfq_image_span_icon">+</span>'+
                            '<span class="wk_mp_rfq_image_span_text">'+$.mage.__("Click here to add sample files") +'...</span>');
                            thisthis.val('');
                            alert({
                                content: content.errormsg
                            });
                        }
                    });
                });
            });
            $('#wk_mp_rfq_create_product').on('click',function(e){
                e.preventDefault();
                $.ajax({
                    url: self.options.createnewproduct,
                    dataType: 'json',
                    showLoader: true,
                    data: {
                        quoteInfoId: self.options.quoteInfoId,
                        sellerId: self.options.sellerId,
                        quoteId: self.options.quoteId,
                        quantity: self.options.quantity,
                        price: self.options.price,
                        productId: self.options.productId,
                        taxClassId: self.options.taxClassId
                    },
                    type: 'POST',
                    success: function (content) {
                        if (content.success == true) {
                            alert({
                                content: content.message,
                                        actions: {
                                            always: function(){setTimeout(function(){ 
                                                location.reload(true); });}
                                        }
                            });
                            // window.location.href = data.Url;
                        }
                        if (content.error == true) {
                            alert({
                                content: content.message
                            });
                        }
                    },
                    error: function (content) {
                    }
                });
            });
            $(document).on('click', '.wk_mp_rfq_image_delete', function () {
                $(this).parents('.wk_mp_rfq_image_box').remove();
            })
    
            $(document).on('keyup', '.wk_mp_rfq_textarea_container', function() {
                $('.wk_mp_rfq_textarea').html($(this).html());
            });
        },
    });
    return $.mage.sellerViewJs;
});
