/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Requestforquote
 * @author    Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
/*jshint jquery:true*/
define([
    "jquery",
    'mage/translate',
    "mage/template",
    'mage/validation',
], function ($, $t, template) {
    'use strict';
    $("#form-rfq-new .wk_req_admin_defined_attribute_input").addClass("validate-no-html-tags");
    $.widget('mage.submitQuotejs', {

        options: {},
        _create: function () {
            var self = this;
            var i = self.options.i;

            $.validator.addMethod(
            'integer', function (value, element) {
            return this.optional(element) || /^-?\d+$/.test(value);
            }, $.mage.__('Please enter a positive non-decimal number in this field.'));

            $.validator.addMethod(
            'validate-script-tags', function (value, element) {
                return !/<script\b[^>]*>([\s\S]*?)<\/script>/.test(value);
            }, $.mage.__('SCRIPT tags are not allowed.'));

            $(document).on('change', '#sample_images', function () {
                var thisthis = $(this);
                var countlength = 0;
                var length = thisthis.prop("files").length;
                $.each(thisthis.prop("files"), function (index, value) {
                    thisthis.parent().find('.wk_mp_rfq_image_label')
                    .html('<div style="position:relative;top:23px;" class="cp-spinner cp-round"></div>');
                    var file_data = thisthis.prop("files")[index];

                    var form_data = new FormData();

                    form_data.append("sample_images", file_data);

                    $.ajax({
                        url: self.options.sampleUpload,
                        dataType: 'json',
                        cache: false,
                        contentType: false,
                        processData: false,
                        data: form_data,
                        type: 'POST',
                        success: function (content) {
                            if(content.type){
                                var templatee = "";
                                var ImageTemplate = template('#requestForQuoteImageTemplate');
                                    templatee += ImageTemplate({
                                    data: {
                                        index:i,
                                        imageUrl:content.fileurl,
                                        imageName:content.filename

                                    }
                                });
                                $(templatee).insertBefore(".wk_mp_rfq_image_label");
                                thisthis.val('');
                                i = i+1;
                                countlength = countlength+1;
                                if (countlength == length) {
                                    thisthis.parent().find('.wk_mp_rfq_image_label')
                                    .html('<span class="wk_mp_rfq_image_span_icon">+</span>'+
                                    '<span class="wk_mp_rfq_image_span_text">'+$.mage.__("Click here to add sample files")+'...</span>');
                                }
                            }else{
                                thisthis.parent().find('.wk_mp_rfq_image_label')
                                .html('<span class="wk_mp_rfq_image_span_icon">+</span>'+
                                '<span class="wk_mp_rfq_image_span_text">'+
                                $.mage.__("Click here to add sample files") +'...</span>');
                                thisthis.val('');
                                alert(content.errormsg);
                            }
                        },
                        error: function (content) {
                            thisthis.parent().find('.wk_mp_rfq_image_label')
                            .html('<span class="wk_mp_rfq_image_span_icon">+</span>'+
                            '<span class="wk_mp_rfq_image_span_text">'+
                            $.mage.__("Click here to add sample files") +'...</span>');
                            thisthis.val('');
                            alert(content.errormsg);
                        }
                    });
                });
            });
            $('#form-rfq-new').on('submit',function(e){
                if ($('#form-rfq-new').validation('isValid') == true) {
                    $('#form-rfq-new button[type="submit"]').attr('disabled','true');
                    return;
                }
                e.preventDefault();
            });
            $(document).on('click', '.wk_mp_rfq_image_delete', function () {
                $(this).parents('.wk_mp_rfq_image_box').remove();
            })

            $(document).on('keyup', '.wk_mp_rfq_textarea_container', function() {
                $('.wk_mp_rfq_textarea').html($(this).html());
            });

            $(document).on('keyup', '.wk_mp_rfq_admin_defined_attribute_textarea_container', function() {
                $('.wk_mp_rfq_admin_defined_attribute_textarea').html($(this).html());
            });
        },
       
    });
    return $.mage.submitQuotejs;
});
